/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.api.common;

import java.time.Duration;
import java.util.Date;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class APIDurationDto
implements Comparable<APIDurationDto> {
    private Duration duration;

    public APIDurationDto() {
        this.duration = Duration.ZERO;
    }

    public APIDurationDto(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void duration(Duration duration) {
        this.duration = this.duration.plus(duration);
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public long getMillis() {
        return this.getDuration().toMillis();
    }

    public void millis(long millis) {
        this.duration = this.duration.plusMillis(millis);
    }

    public void setMillis(long millis) {
        this.duration = Duration.ofMillis(millis);
    }

    public int getSeconds() {
        return Math.toIntExact(this.getDuration().toSeconds());
    }

    public void seconds(int seconds) {
        this.duration = this.duration.plusSeconds(seconds);
    }

    public void setSeconds(int seconds) {
        this.duration = Duration.ofSeconds(seconds);
    }

    public int getMinutes() {
        return Math.toIntExact(this.getDuration().toMinutes());
    }

    public void minutes(int minutes) {
        this.duration = this.duration.plusMinutes(minutes);
    }

    public void setMinutes(int minutes) {
        this.duration = Duration.ofMinutes(minutes);
    }

    public int getHours() {
        return Math.toIntExact(this.getDuration().toHours());
    }

    public void hours(int hours) {
        this.duration = this.duration.plusHours(hours);
    }

    public void setHours(int hours) {
        this.duration = Duration.ofHours(hours);
    }

    public int getDays() {
        return Math.toIntExact(this.getDuration().toDays());
    }

    public void days(int days) {
        this.duration = this.duration.plusDays(days);
    }

    private void setDays(int days) {
        this.duration = Duration.ofDays(days);
    }

    public void since(Date date) {
        this.since(date.getTime());
    }

    public void since(long timeStamp) {
        long millisPassed = System.currentTimeMillis() - timeStamp;
        this.duration = Duration.ofMillis(millisPassed);
    }

    public void until(Date date) {
        this.until(date.getTime());
    }

    public void until(long timeStamp) {
        long millisUntil = timeStamp - System.currentTimeMillis();
        this.duration = Duration.ofMillis(millisUntil);
    }

    public String getDisplayString() {
        int days = (int)this.duration.toDays();
        int hours = this.duration.toHoursPart();
        int minutes = this.duration.toMinutesPart();
        int seconds = this.duration.toSecondsPart();
        if (days == 0 && hours == 0 && minutes == 0 && seconds == 0) {
            return "0d 0h 0m 0s";
        }
        Object daysString = days > 0 ? days + "d" : "";
        Object hoursString = hours > 0 ? hours + "h" : "";
        Object minutesString = minutes > 0 ? minutes + "m" : "";
        Object secondsString = seconds > 0 ? seconds + "s" : "";
        return Stream.of(daysString, hoursString, minutesString, secondsString).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(" "));
    }

    @Override
    public int compareTo(APIDurationDto o) {
        return this.duration.compareTo(o.duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIDurationDto that = (APIDurationDto)o;
        return Objects.equals(this.duration, that.duration);
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    public String toString() {
        return this.getDisplayString();
    }
}

