/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.api.common;

import com.equestricraft.api.common.APIAlleleDto;
import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIPlayerDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APIHorseCreateRequestDto {
    private APIPlayerDto owner;
    private String name;
    private String gender;
    private Integer ageMonths;
    private APIHorseDto mother;
    private APIHorseDto father;
    private Map<APIAlleleDto, String> alleleDominanceMap = new HashMap<APIAlleleDto, String>(0);
    private Double currentValue;
    private String color;
    private List<String> markings = new ArrayList<String>(0);
    private boolean gray;
    private boolean bypassHorseLimit;
    private double finalWeight;
    private double finalHeight;
    private boolean forceImmortal;
    private Integer ownerTrustLevel;
    private boolean ownedByPlayer;
    private Map<String, Double> tags = new HashMap<String, Double>(0);

    public APIHorseCreateRequestDto() {
    }

    public APIHorseCreateRequestDto(APIPlayerDto owner, String name, String gender, Integer ageMonths, APIHorseDto mother, APIHorseDto father, Map<APIAlleleDto, String> alleleDominanceMap, Double currentValue, String color, List<String> markings, boolean gray, boolean bypassHorseLimit, double finalWeight, double finalHeight, boolean forceImmortal, Integer ownerTrustLevel, boolean ownedByPlayer, Map<String, Double> tags) {
        this.owner = owner;
        this.name = name;
        this.gender = gender;
        this.ageMonths = ageMonths;
        this.mother = mother;
        this.father = father;
        this.alleleDominanceMap = alleleDominanceMap;
        this.currentValue = currentValue;
        this.color = color;
        this.markings = markings;
        this.gray = gray;
        this.bypassHorseLimit = bypassHorseLimit;
        this.finalWeight = finalWeight;
        this.finalHeight = finalHeight;
        this.forceImmortal = forceImmortal;
        this.ownerTrustLevel = ownerTrustLevel;
        this.ownedByPlayer = ownedByPlayer;
        this.tags = tags;
    }

    public APIPlayerDto getOwner() {
        return this.owner;
    }

    public void setOwner(APIPlayerDto owner) {
        this.owner = owner;
    }

    public void owner(APIPlayerDto owner) {
        this.setOwner(owner);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String name) {
        this.setName(name);
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void gender(String gender) {
        this.setGender(gender);
    }

    public Integer getAgeMonths() {
        return this.ageMonths;
    }

    public void setAgeMonths(Integer ageMonths) {
        this.ageMonths = ageMonths;
    }

    public void ageMonths(Integer ageMonths) {
        this.setAgeMonths(ageMonths);
    }

    public APIHorseDto getMother() {
        return this.mother;
    }

    public void setMother(APIHorseDto mother) {
        this.mother = mother;
    }

    public void mother(APIHorseDto mother) {
        this.setMother(mother);
    }

    public APIHorseDto getFather() {
        return this.father;
    }

    public void setFather(APIHorseDto father) {
        this.father = father;
    }

    public void father(APIHorseDto father) {
        this.setFather(father);
    }

    public Map<APIAlleleDto, String> getAlleleDominanceMap() {
        return this.alleleDominanceMap;
    }

    public void setAlleleDominanceMap(Map<APIAlleleDto, String> alleleDominanceMap) {
        this.alleleDominanceMap = alleleDominanceMap;
    }

    public void alleleDominanceMap(Map<APIAlleleDto, String> alleleDominanceMap) {
        this.setAlleleDominanceMap(alleleDominanceMap);
    }

    public void alleleDominance(APIAlleleDto allele, String dominance) {
        this.alleleDominanceMap.put(allele, dominance);
    }

    public Double getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(Double currentValue) {
        this.currentValue = currentValue;
    }

    public void currentValue(Double currentValue) {
        this.setCurrentValue(currentValue);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void color(String color) {
        this.setColor(color);
    }

    public List<String> getMarkings() {
        return this.markings;
    }

    public void setMarkings(List<String> markings) {
        this.markings = markings;
    }

    public void markings(List<String> markings) {
        this.setMarkings(markings);
    }

    public void marking(String marking) {
        this.markings.add(marking);
    }

    public boolean isGray() {
        return this.gray;
    }

    public void setGray(boolean gray) {
        this.gray = gray;
    }

    public void gray(boolean gray) {
        this.setGray(gray);
    }

    public boolean isBypassHorseLimit() {
        return this.bypassHorseLimit;
    }

    public void setBypassHorseLimit(boolean bypassHorseLimit) {
        this.bypassHorseLimit = bypassHorseLimit;
    }

    public void bypassHorseLimit(boolean bypassHorseLimit) {
        this.setBypassHorseLimit(bypassHorseLimit);
    }

    public Double getFinalWeight() {
        return this.finalWeight;
    }

    public void setFinalWeight(double finalWeight) {
        this.finalWeight = finalWeight;
    }

    public void finalWeight(double finalWeight) {
        this.setFinalWeight(finalWeight);
    }

    public Double getFinalHeight() {
        return this.finalHeight;
    }

    public void setFinalHeight(double finalHeight) {
        this.finalHeight = finalHeight;
    }

    public void finalHeight(double finalHeight) {
        this.setFinalHeight(finalHeight);
    }

    public boolean isForceImmortal() {
        return this.forceImmortal;
    }

    public void setForceImmortal(boolean forceImmortal) {
        this.forceImmortal = forceImmortal;
    }

    public void forceImmortal(boolean forceImmortal) {
        this.setForceImmortal(forceImmortal);
    }

    public Integer getOwnerTrustLevel() {
        return this.ownerTrustLevel;
    }

    public void setOwnerTrustLevel(Integer ownerTrustLevel) {
        this.ownerTrustLevel = ownerTrustLevel;
    }

    public void ownerTrustLevel(Integer ownerTrustLevel) {
        this.setOwnerTrustLevel(ownerTrustLevel);
    }

    public boolean isOwnedByPlayer() {
        return this.ownedByPlayer;
    }

    public void setOwnedByPlayer(boolean ownedByPlayer) {
        this.ownedByPlayer = ownedByPlayer;
    }

    public void ownedByPlayer(boolean ownedByPlayer) {
        this.setOwnedByPlayer(ownedByPlayer);
    }

    public Map<String, Double> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Double> tags) {
        this.tags = tags;
    }

    public void tags(Map<String, Double> tags) {
        this.setTags(tags);
    }

    public void tag(String tag, double value) {
        this.tags.put(tag, value);
    }

    public static class Builder {
        private APIPlayerDto owner;
        private String name;
        private String gender;
        private Integer ageMonths;
        private APIHorseDto mother;
        private APIHorseDto father;
        private Map<APIAlleleDto, String> alleleDominanceMap = new HashMap<APIAlleleDto, String>(0);
        private Double currentValue = null;
        private String color;
        private List<String> markings = new ArrayList<String>(0);
        private boolean gray = false;
        private boolean bypassHorseLimit = false;
        private Double finalWeight = null;
        private Double finalHeight = null;
        private boolean forceImmortal = false;
        private Integer ownerTrustLevel = null;
        private boolean ownedByPlayer = true;
        private Map<String, Double> tags = new HashMap<String, Double>(0);

        private Builder() {
        }

        public Builder withOwner(APIPlayerDto owner) {
            this.owner = owner;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withGender(String gender) {
            this.gender = gender;
            return this;
        }

        public Builder withAgeMonths(Integer ageMonths) {
            this.ageMonths = ageMonths;
            return this;
        }

        public Builder withParents(APIHorseDto mother, APIHorseDto father) {
            this.mother = mother;
            this.father = father;
            return this;
        }

        public Builder withAllele(APIAlleleDto allele, String dominance) {
            this.alleleDominanceMap.put(allele, dominance);
            return this;
        }

        public Builder withAlleleDominanceMap(Map<APIAlleleDto, String> alleleDominanceMap) {
            this.alleleDominanceMap = new HashMap<APIAlleleDto, String>(alleleDominanceMap);
            return this;
        }

        public Builder withCurrentValue(Double currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        public Builder withColor(String color) {
            this.color = color;
            return this;
        }

        public Builder withMarking(String marking) {
            this.markings.add(marking);
            return this;
        }

        public Builder withMarkings(List<String> markings) {
            this.markings = markings;
            return this;
        }

        public Builder withGray(boolean gray) {
            this.gray = gray;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder withBodyType(String bodyType) {
            return this;
        }

        public Builder withBypassHorseLimit(boolean bypassHorseLimit) {
            this.bypassHorseLimit = bypassHorseLimit;
            return this;
        }

        public Builder withFinalWeight(Double finalWeight) {
            this.finalWeight = finalWeight;
            return this;
        }

        public Builder withFinalHeight(Double finalHeight) {
            this.finalHeight = finalHeight;
            return this;
        }

        public Builder withForceImmortal(boolean forceImmortal) {
            this.forceImmortal = forceImmortal;
            return this;
        }

        public Builder forceImmortal() {
            return this.withForceImmortal(true);
        }

        public Builder withOwnerTrustLevel(Integer ownerTrustLevel) {
            this.ownerTrustLevel = ownerTrustLevel;
            return this;
        }

        public Builder withNoTrust() {
            return this.withOwnerTrustLevel(0);
        }

        public Builder withFullTrust() {
            return this.withOwnerTrustLevel(100);
        }

        public Builder withOwnedByPlayer(boolean ownedByPlayer) {
            this.ownedByPlayer = ownedByPlayer;
            return this;
        }

        public Builder notOwnedByPlayer() {
            return this.withOwnedByPlayer(false);
        }

        public Builder withTag(String tag, double value) {
            this.tags.put(tag, value);
            return this;
        }

        public Builder withTags(Map<String, Double> tags) {
            this.tags = new HashMap<String, Double>(tags);
            return this;
        }

        public APIHorseCreateRequestDto complete() {
            return new APIHorseCreateRequestDto(this.owner, this.name, this.gender, this.ageMonths, this.mother, this.father, this.alleleDominanceMap, this.currentValue, this.color, this.markings, this.gray, this.bypassHorseLimit, this.finalWeight, this.finalHeight, this.forceImmortal, this.ownerTrustLevel, this.ownedByPlayer, this.tags);
        }

        public static Builder start() {
            return new Builder();
        }
    }
}

