/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.Credentials;
import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.logging.Log;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class DataSource {
    private static HikariDataSource hikariDataSource = null;
    private static final int POOL_SIZE = 50;
    private static final Log log = Log.getLogger(DataSource.class.getName());

    protected static void connect(Credentials credentials) {
        HikariConfig config = new HikariConfig();
        String connectionURL = "jdbc:mysql://" + credentials.getUrl();
        if (credentials.getDatabaseName() != null) {
            connectionURL = connectionURL + "/" + credentials.getDatabaseName();
        }
        connectionURL = connectionURL + "?verifyServerCertificate=false";
        log.info("Connecting to database {}", (Object)connectionURL);
        config.setJdbcUrl(connectionURL);
        config.setUsername(credentials.getUsername());
        config.setPassword(credentials.getPassword());
        config.setAutoCommit(false);
        config.setMaximumPoolSize(DataSource.getPoolSize());
        hikariDataSource = new HikariDataSource(config);
        log.info("Maximum Database Connection Pool Size: {}", (Object)hikariDataSource.getMaximumPoolSize());
    }

    public static Connection getManualCommitConnection() {
        return DataSource.getConnection(false);
    }

    public static Connection getAutoCommitConnection() {
        return DataSource.getConnection(true);
    }

    public static Connection getConnection(boolean autoCommit) {
        DataSource.ensureReady();
        try {
            Connection connection = hikariDataSource.getConnection();
            connection.setAutoCommit(autoCommit);
            return connection;
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public static void shutdown() {
        if (hikariDataSource == null) {
            return;
        }
        log.info("Shutting down database connection pool");
        hikariDataSource.close();
    }

    private static void ensureReady() {
        if (hikariDataSource == null) {
            throw new DatabaseException("Database not connected");
        }
    }

    private static int getPoolSize() {
        return Integer.parseInt(System.getProperty("equestricraft.max-database-pool", "50"));
    }

    private DataSource() {
    }
}

