/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DatabaseConnectionContext;
import java.sql.Connection;
import java.sql.SQLException;

public class DatabaseConnectionContainer {
    private static final DatabaseConnectionContainer connectionContainer = new DatabaseConnectionContainer();
    private final ThreadLocal<DatabaseConnectionContext> threadLocal = ThreadLocal.withInitial(DatabaseConnectionContext::new);

    protected static DatabaseConnectionContainer getInstance() {
        return connectionContainer;
    }

    private DatabaseConnectionContainer() {
    }

    public void setConnection(Connection connection) {
        this.threadLocal.get().setConnection(connection);
    }

    protected Connection getConnection() {
        return this.threadLocal.get().getConnection();
    }

    protected void clearConnection() {
        this.threadLocal.remove();
    }

    protected void incrementLayer() {
        this.threadLocal.get().incrementLayer();
    }

    protected void decrementLayer() {
        this.threadLocal.get().decrementLayer();
    }

    protected boolean atStartLayer() {
        return this.threadLocal.get().getLayers() == 0;
    }

    protected boolean isInTransaction() throws SQLException {
        Connection connection = this.getConnection();
        return connection != null && !connection.getAutoCommit();
    }
}

