/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DataSource;
import com.equestricraft.base.database.DatabaseConnectionContainer;
import com.equestricraft.base.database.DatabaseException;
import java.sql.Connection;
import java.sql.SQLException;

public class DatabaseTransactionHelper {
    private static final DatabaseConnectionContainer connectionContainer = DatabaseConnectionContainer.getInstance();

    public static void startDatabaseTransaction() {
        try {
            if (connectionContainer.isInTransaction()) {
                connectionContainer.incrementLayer();
            } else {
                Connection connection = DataSource.getManualCommitConnection();
                connectionContainer.setConnection(connection);
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public static void commitDatabaseTransaction() {
        if (connectionContainer.atStartLayer()) {
            Connection connection = connectionContainer.getConnection();
            try {
                connection.commit();
                connection.close();
                connectionContainer.clearConnection();
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
        } else {
            connectionContainer.decrementLayer();
        }
    }

    public static void rollbackDatabaseTransaction() {
        if (connectionContainer.atStartLayer()) {
            Connection connection = connectionContainer.getConnection();
            try {
                connection.rollback();
                connection.close();
                connectionContainer.clearConnection();
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
        } else {
            connectionContainer.decrementLayer();
        }
    }

    private DatabaseTransactionHelper() {
    }
}

