/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.logging.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class DeleteQuery
extends Query {
    private QueryColumn<?>[] whereConditions = null;
    private String whereConditionString = null;
    private static final Log log = Log.getLogger(DeleteQuery.class.getName());

    DeleteQuery(String tableName) {
        super(tableName);
    }

    public DeleteQuery where(QueryColumn<?> ... condition) {
        this.whereConditions = condition;
        this.whereConditionString = null;
        return this;
    }

    public DeleteQuery where(String whereConditionString) {
        this.whereConditionString = whereConditionString;
        this.whereConditions = null;
        return this;
    }

    public int execute() {
        int n;
        block8: {
            PreparedStatement s = this.buildPreparedStatement();
            try {
                n = s.executeUpdate();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    log.error("Error executing query: {}", (Object)this.queryString);
                    throw new DatabaseException(ex);
                }
            }
            s.close();
        }
        return n;
    }

    private PreparedStatement buildPreparedStatement() throws SQLException {
        this.buildQueryString();
        PreparedStatement s = this.connection().prepareStatement(this.queryString);
        if (this.whereConditions != null) {
            this.setParam(s, this.whereConditions);
        }
        return s;
    }

    private void buildQueryString() {
        this.queryString = String.format("DELETE FROM %s ", this.tableName);
        if (this.whereConditions != null) {
            String whereString = Arrays.stream(this.whereConditions).map(c -> String.format("%s = ?", c.name())).collect(Collectors.joining(" AND "));
            this.queryString = this.queryString + String.format("WHERE %s", whereString);
        } else if (this.whereConditionString != null) {
            this.queryString = this.queryString + this.whereConditionString;
        }
    }
}

