/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.logging.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;

public final class InsertQuery
extends Query {
    private final List<QueryColumn<?>> columns = new LinkedList();
    private String[] onDuplicateKeyUpdate = null;
    private static final Log log = Log.getLogger(InsertQuery.class.getName());

    InsertQuery(String tableName) {
        super(tableName);
    }

    public InsertQuery columns(QueryColumn<?> ... columns) {
        Collections.addAll(this.columns, columns);
        return this;
    }

    public InsertQuery onDuplicateKeyUpdate(String ... onDuplicateKeyUpdate) {
        this.onDuplicateKeyUpdate = onDuplicateKeyUpdate;
        return this;
    }

    public int execute() {
        int n;
        block8: {
            PreparedStatement s = this.buildPreparedStatement(false);
            try {
                n = s.executeUpdate();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    log.error("Error executing query: {}", (Object)this.queryString);
                    throw new DatabaseException(ex);
                }
            }
            s.close();
        }
        return n;
    }

    public int executeGetGeneratedKey(IntConsumer keyConsumer) {
        int n;
        block9: {
            PreparedStatement s = this.buildPreparedStatement(true);
            try {
                int count = s.executeUpdate();
                ResultSet set2 = s.getGeneratedKeys();
                if (set2.next()) {
                    keyConsumer.accept(set2.getInt(1));
                }
                n = count;
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    log.error("Error executing query: {}", (Object)this.queryString);
                    throw new DatabaseException(ex);
                }
            }
            s.close();
        }
        return n;
    }

    public int executeGetGeneratedKey(LongConsumer keyConsumer) {
        int n;
        block9: {
            PreparedStatement s = this.buildPreparedStatement(true);
            try {
                int count = s.executeUpdate();
                ResultSet set2 = s.getGeneratedKeys();
                if (set2.next()) {
                    keyConsumer.accept(set2.getLong(1));
                }
                n = count;
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    log.error("Error executing query: {}", (Object)this.queryString);
                    throw new DatabaseException(ex);
                }
            }
            s.close();
        }
        return n;
    }

    private PreparedStatement buildPreparedStatement(boolean generateKeys) throws SQLException {
        this.buildQueryString();
        PreparedStatement s = generateKeys ? this.connection().prepareStatement(this.queryString, 1) : this.connection().prepareStatement(this.queryString);
        AtomicInteger currentColumnNumber = new AtomicInteger(1);
        for (QueryColumn<?> column : this.columns) {
            this.setParam(s, currentColumnNumber, column);
        }
        return s;
    }

    private void buildQueryString() {
        String columnsNames = this.columns.stream().map(QueryColumn::name).collect(Collectors.joining(", "));
        String valuePlaceholders = this.columns.stream().map(c -> "?").collect(Collectors.joining(","));
        this.queryString = String.format("INSERT INTO %s (%s) VALUES (%s)", this.tableName, columnsNames, valuePlaceholders);
        if (this.onDuplicateKeyUpdate != null) {
            this.queryString = this.queryString + " ON DUPLICATE KEY UPDATE ";
            this.queryString = this.queryString + String.join((CharSequence)", ", Arrays.asList(this.onDuplicateKeyUpdate));
        }
    }
}

