/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.Credentials;
import com.equestricraft.base.database.DataSource;
import com.equestricraft.base.database.Database;
import com.equestricraft.base.database.DatabaseConnectionContainer;
import com.equestricraft.base.database.DatabaseConnectionException;
import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.thread.ThreadChecker;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;

public class MySQL
extends Database {
    private final DatabaseConnectionContainer connectionContainer = DatabaseConnectionContainer.getInstance();
    private boolean acceptingConnections = true;

    public MySQL(Credentials credentials) throws DatabaseConnectionException {
        super(credentials);
    }

    @Override
    public void connect() throws DatabaseConnectionException {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new DatabaseConnectionException(ex);
        }
        DataSource.connect(this.credentials);
        this.connection = DataSource.getAutoCommitConnection();
        this.isDatabaseOnline();
    }

    @Override
    public Connection getSQLConnection() throws SQLException {
        this.ensureAcceptingConnections();
        return this.getConnection();
    }

    private void ensureAcceptingConnections() {
        if (!this.acceptingConnections) {
            throw new DatabaseException("Database is shutting down. Connections are not being accepted");
        }
    }

    private Connection getConnection() throws SQLException {
        ThreadChecker.warnIfServerThread("Database connection on main server thread");
        Connection conn = this.connectionContainer.getConnection();
        if (conn == null) {
            if (this.connection.isClosed()) {
                this.connection = DataSource.getAutoCommitConnection();
            }
            return this.connection;
        }
        return conn;
    }

    @Override
    public void close() throws SQLException {
        this.acceptingConnections = false;
        this.connection.close();
        DataSource.shutdown();
    }
}

