/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.Database;
import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.DeleteQuery;
import com.equestricraft.base.database.InsertQuery;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.SelectQuery;
import com.equestricraft.base.database.UpdateQuery;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.CoordinateUtility;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Query {
    final String tableName;
    String queryString = null;
    protected static final String QUERY_ERROR_LOG_MESSAGE = "Error executing query: {}";

    public static PreparedStatement prepare(String sql) {
        try {
            return Services.getService(Database.class).getSQLConnection().prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public static SelectQuery selectAllFrom(String tableName) {
        return new SelectQuery(tableName);
    }

    public static InsertQuery insertInto(String tableName) {
        return new InsertQuery(tableName);
    }

    public static UpdateQuery update(String tableName) {
        return new UpdateQuery(tableName);
    }

    public static DeleteQuery deleteFrom(String tableName) {
        return new DeleteQuery(tableName);
    }

    Query(String tableName) {
        this.tableName = tableName;
    }

    protected Connection connection() throws SQLException {
        return Services.getService(Database.class).getSQLConnection();
    }

    protected void setParam(PreparedStatement s, QueryColumn<?>[] columns) throws SQLException {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        for (QueryColumn<?> queryColumn : columns) {
            this.setParam(s, atomicInteger, queryColumn);
        }
    }

    protected void setParam(PreparedStatement s, AtomicInteger currentColumnNumber, QueryColumn<?> column) throws SQLException {
        if (column.value() == null) {
            s.setNull(currentColumnNumber.get(), column.type().getSqlType());
        } else {
            switch (column.type()) {
                case STRING: {
                    s.setString(currentColumnNumber.get(), column.value().toString());
                    break;
                }
                case INTEGER: {
                    s.setInt(currentColumnNumber.get(), (Integer)column.value());
                    break;
                }
                case DOUBLE: {
                    s.setDouble(currentColumnNumber.get(), (Double)column.value());
                    break;
                }
                case LONG: {
                    s.setLong(currentColumnNumber.get(), (Long)column.value());
                    break;
                }
                case DATE: {
                    s.setLong(currentColumnNumber.get(), ((Date)column.value()).getTime());
                    break;
                }
                case BOOLEAN: {
                    s.setBoolean(currentColumnNumber.get(), (Boolean)column.value());
                    break;
                }
                case BLOB: {
                    s.setBlob(currentColumnNumber.get(), new ByteArrayInputStream((byte[])column.value()));
                    break;
                }
                case FLOAT: {
                    s.setFloat(currentColumnNumber.get(), ((Float)column.value()).floatValue());
                    break;
                }
                case COORDINATE: {
                    s.setString(currentColumnNumber.get(), CoordinateUtility.serializeCoordinate((Coordinate)column.value()));
                    break;
                }
                case BLOCK_COORDINATE: {
                    s.setString(currentColumnNumber.get(), CoordinateUtility.serializeBlockCoordinate((BlockCoordinate)column.value()));
                    break;
                }
                case DIRECTIONAL_COORDINATE: {
                    s.setString(currentColumnNumber.get(), CoordinateUtility.serializeDirectionalCoordinate((DirectionalCoordinate)column.value()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + column.value().getClass().getName());
                }
            }
        }
        currentColumnNumber.incrementAndGet();
    }
}

