/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.QueryParamType;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import java.util.Date;
import java.util.UUID;

public record QueryColumn<T>(String name, T value, QueryParamType type) {
    public static QueryColumn<String> column(String columnName, String value) {
        return new QueryColumn<String>(columnName, value, QueryParamType.STRING);
    }

    public static QueryColumn<UUID> column(String columnName, UUID value) {
        return new QueryColumn<UUID>(columnName, value, QueryParamType.STRING);
    }

    public static QueryColumn<Integer> column(String columnName, Integer value) {
        return new QueryColumn<Integer>(columnName, value, QueryParamType.INTEGER);
    }

    public static QueryColumn<Double> column(String columnName, Double value) {
        return new QueryColumn<Double>(columnName, value, QueryParamType.DOUBLE);
    }

    public static QueryColumn<Long> column(String columnName, Long value) {
        return new QueryColumn<Long>(columnName, value, QueryParamType.LONG);
    }

    public static QueryColumn<Date> column(String columnName, Date value) {
        return new QueryColumn<Date>(columnName, value, QueryParamType.DATE);
    }

    public static QueryColumn<Boolean> column(String columnName, Boolean value) {
        return new QueryColumn<Boolean>(columnName, value, QueryParamType.BOOLEAN);
    }

    public static QueryColumn<byte[]> column(String columnName, byte[] value) {
        return new QueryColumn<byte[]>(columnName, value, QueryParamType.BLOB);
    }

    public static QueryColumn<Float> column(String columnName, Float value) {
        return new QueryColumn<Float>(columnName, value, QueryParamType.FLOAT);
    }

    public static <E extends Enum<E>> QueryColumn<String> column(String columnName, E enumValue) {
        return QueryColumn.column(columnName, enumValue != null ? enumValue.name() : null);
    }

    public static QueryColumn<Coordinate> column(String columnName, Coordinate value) {
        return new QueryColumn<Coordinate>(columnName, value, QueryParamType.COORDINATE);
    }

    public static QueryColumn<BlockCoordinate> column(String columnName, BlockCoordinate value) {
        return new QueryColumn<BlockCoordinate>(columnName, value, QueryParamType.BLOCK_COORDINATE);
    }

    public static QueryColumn<DirectionalCoordinate> column(String columnName, DirectionalCoordinate value) {
        return new QueryColumn<DirectionalCoordinate>(columnName, value, QueryParamType.DIRECTIONAL_COORDINATE);
    }
}

