/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.base.worldarea.WorldAreaUtil;
import com.equestricraft.common.Argb;
import com.equestricraft.common.DaysOfWeek;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.CoordinateUtility;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.coordinate.GeometryUtil;
import java.awt.geom.Path2D;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;

public class ResultRow {
    private final ResultSet resultSet;
    private static final String NULL_MESSAGE = "Value returned for column was null";

    protected ResultRow(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public String getString(String columnName) {
        return Objects.requireNonNull(this.getNullableString(columnName), NULL_MESSAGE);
    }

    public String getNullableString(String columnName) {
        try {
            return this.resultSet.getString(columnName);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public boolean getBoolean(String columnName) {
        return Objects.requireNonNull(this.getNullableBoolean(columnName), NULL_MESSAGE);
    }

    public Boolean getNullableBoolean(String columnName) {
        try {
            boolean value = this.resultSet.getBoolean(columnName);
            return this.resultSet.wasNull() ? null : Boolean.valueOf(value);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public int getInt(String columnName) {
        return Objects.requireNonNull(this.getNullableInt(columnName), NULL_MESSAGE);
    }

    public Integer getNullableInt(String columnName) {
        try {
            int value = this.resultSet.getInt(columnName);
            return this.resultSet.wasNull() ? null : Integer.valueOf(value);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public double getDouble(String columnName) {
        return Objects.requireNonNull(this.getNullableDouble(columnName), NULL_MESSAGE);
    }

    public Double getNullableDouble(String columnName) {
        try {
            double value = this.resultSet.getDouble(columnName);
            return this.resultSet.wasNull() ? null : Double.valueOf(value);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public long getLong(String columnName) {
        return Objects.requireNonNull(this.getNullableLong(columnName), NULL_MESSAGE);
    }

    public Long getNullableLong(String columnName) {
        try {
            long value = this.resultSet.getLong(columnName);
            return this.resultSet.wasNull() ? null : Long.valueOf(value);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public float getFloat(String columnName) {
        return Objects.requireNonNull(this.getNullableFloat(columnName), NULL_MESSAGE).floatValue();
    }

    public Float getNullableFloat(String columnName) {
        try {
            float value = this.resultSet.getFloat(columnName);
            return this.resultSet.wasNull() ? null : Float.valueOf(value);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public Date getDate(String columnName) {
        return Objects.requireNonNull(this.getNullableDate(columnName), NULL_MESSAGE);
    }

    public Date getNullableDate(String columnName) {
        try {
            Date value = new Date(this.resultSet.getLong(columnName));
            return this.resultSet.wasNull() ? null : value;
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public UUID getUuid(String columnName) {
        return Objects.requireNonNull(this.getNullableUuid(columnName), NULL_MESSAGE);
    }

    public UUID getNullableUuid(String columnName) {
        String stringValue = this.getNullableString(columnName);
        return stringValue == null ? null : UUID.fromString(stringValue);
    }

    public byte[] getByteArray(String columnName) {
        try {
            Blob blob = this.resultSet.getBlob(columnName);
            if (blob == null) {
                return new byte[0];
            }
            return blob.getBinaryStream().readAllBytes();
        }
        catch (IOException | SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public <E extends Enum<E>> E getEnum(String columnName, Class<E> enumClass) {
        return (E)((Enum)Objects.requireNonNull(this.getNullableEnum(columnName, enumClass), NULL_MESSAGE));
    }

    public <E extends Enum<E>> E getNullableEnum(String columnName, Class<E> enumClass) {
        String stringValue = this.getNullableString(columnName);
        if (stringValue == null) {
            return null;
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!stringValue.equals(e.name())) continue;
            return (E)e;
        }
        throw new IllegalArgumentException(String.format("Invalid enum value %s for enum class %s", stringValue, enumClass.getName()));
    }

    public Coordinate getCoordinate(String columnName) {
        return Objects.requireNonNull(this.getNullableCoordinate(columnName), NULL_MESSAGE);
    }

    public Coordinate getNullableCoordinate(String columnName) {
        String stringValue = this.getNullableString(columnName);
        return stringValue != null ? CoordinateUtility.deserializeCoordinate(stringValue) : null;
    }

    public BlockCoordinate getBlockCoordinate(String columnName) {
        return Objects.requireNonNull(this.getNullableBlockCoordinate(columnName), NULL_MESSAGE);
    }

    public BlockCoordinate getNullableBlockCoordinate(String columnName) {
        String stringValue = this.getNullableString(columnName);
        return stringValue != null ? CoordinateUtility.deserializeBlockCoordinate(stringValue) : null;
    }

    public DirectionalCoordinate getDirectionalCoordinate(String columnName) {
        return Objects.requireNonNull(this.getNullableDirectionalCoordinate(columnName), NULL_MESSAGE);
    }

    public DirectionalCoordinate getNullableDirectionalCoordinate(String columnName) {
        String stringValue = this.getNullableString(columnName);
        return stringValue != null ? CoordinateUtility.deserializeDirectionalCoordinate(stringValue) : null;
    }

    public Path2D getPath2D(String columnName) {
        return Objects.requireNonNull(this.getNullablePath2D(columnName), NULL_MESSAGE);
    }

    public Path2D getNullablePath2D(String columnName) {
        String stringValue = this.getNullableString(columnName);
        return stringValue != null ? GeometryUtil.buildPathFromGeometryString(stringValue) : null;
    }

    public WorldArea getWorldArea(String columnName) {
        return Objects.requireNonNull(this.getNullableWorldArea(columnName), NULL_MESSAGE);
    }

    public WorldArea getNullableWorldArea(String columnName) {
        String stringValue = this.getNullableString(columnName);
        return stringValue != null ? WorldAreaUtil.toWorldArea(stringValue) : null;
    }

    public DaysOfWeek getDaysOfWeek(String columnName) {
        return Objects.requireNonNull(this.getNullableDaysOfWeek(columnName), NULL_MESSAGE);
    }

    public DaysOfWeek getNullableDaysOfWeek(String columnName) {
        Integer intValue = this.getNullableInt(columnName);
        return intValue != null ? DaysOfWeek.fromInt(intValue) : null;
    }

    public Argb getArgbColor(String columnName) {
        return Objects.requireNonNull(this.getNullableArgbColor(columnName), NULL_MESSAGE);
    }

    public Argb getNullableArgbColor(String columnName) {
        Integer intValue = this.getNullableInt(columnName);
        return intValue != null ? Argb.fromIntValue(intValue) : null;
    }
}

