/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.database.ResultRowFunction;
import com.equestricraft.logging.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class SelectQuery
extends Query {
    private QueryColumn<?>[] whereConditions = null;
    private String whereConditionString = null;
    private String orderBy = null;
    private String groupBy = null;
    private int limitValue = 0;
    private static final Log log = Log.getLogger(SelectQuery.class.getName());

    SelectQuery(String tableName) {
        super(tableName);
    }

    public SelectQuery where(QueryColumn<?> ... condition) {
        this.whereConditions = condition;
        this.whereConditionString = null;
        return this;
    }

    public SelectQuery where(String whereConditionString) {
        this.whereConditionString = whereConditionString;
        this.whereConditions = null;
        return this;
    }

    public SelectQuery orderBy(String orderByClause) {
        this.orderBy = orderByClause;
        return this;
    }

    public SelectQuery groupBy(String groupByClause) {
        this.groupBy = groupByClause;
        return this;
    }

    public SelectQuery limit(int limitValue) {
        this.limitValue = limitValue;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> Optional<T> getSingle(ResultRowFunction<T> builder) {
        try (PreparedStatement statement = this.buildPreparedStatement();){
            Optional optional;
            block18: {
                ResultSet set2;
                block16: {
                    Optional<T> optional2;
                    block17: {
                        set2 = statement.executeQuery();
                        try {
                            ResultRow resultRow = new ResultRow(set2);
                            if (!set2.next()) break block16;
                            optional2 = Optional.ofNullable(builder.apply(resultRow));
                            if (set2 == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (set2 != null) {
                                try {
                                    set2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        set2.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (set2 == null) break block18;
                set2.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            log.error("Error executing query: {}", (Object)this.queryString);
            throw new DatabaseException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> getList(ResultRowFunction<T> builder) {
        try (PreparedStatement statement = this.buildPreparedStatement();){
            LinkedList<T> linkedList;
            block15: {
                ResultSet set2 = statement.executeQuery();
                try {
                    ResultRow resultRow = new ResultRow(set2);
                    LinkedList<T> list = new LinkedList<T>();
                    while (set2.next()) {
                        list.add(builder.apply(resultRow));
                    }
                    linkedList = list;
                    if (set2 == null) break block15;
                }
                catch (Throwable throwable) {
                    if (set2 != null) {
                        try {
                            set2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                set2.close();
            }
            return linkedList;
        }
        catch (SQLException ex) {
            log.error("Error executing query: {}", (Object)this.queryString);
            throw new DatabaseException(ex);
        }
    }

    private PreparedStatement buildPreparedStatement() throws SQLException {
        this.buildQueryString();
        PreparedStatement s = this.connection().prepareStatement(this.queryString);
        if (this.whereConditions != null) {
            AtomicInteger currentColumnCount = new AtomicInteger(1);
            for (QueryColumn<?> whereCondition : this.whereConditions) {
                this.setParam(s, currentColumnCount, whereCondition);
            }
        }
        return s;
    }

    private void buildQueryString() {
        StringBuilder query = new StringBuilder(String.format("SELECT * FROM %s ", this.tableName));
        if (this.whereConditions != null) {
            String whereClauses = Arrays.stream(this.whereConditions).map(c -> String.format("%s = ?", c.name())).collect(Collectors.joining(" AND "));
            query.append(String.format("WHERE %s", whereClauses));
        } else if (this.whereConditionString != null) {
            query.append(this.whereConditionString);
        }
        if (this.orderBy != null) {
            query.append(String.format(" ORDER BY %s", this.orderBy));
        }
        if (this.groupBy != null) {
            query.append(String.format(" GROUP BY %s", this.groupBy));
        }
        if (this.limitValue > 0) {
            query.append(String.format(" LIMIT %s", this.limitValue));
        }
        this.queryString = query.toString().trim();
    }
}

