/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DataSource;
import com.equestricraft.base.database.DatabaseConnectionContainer;
import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.ServiceInvocationHandler;
import com.equestricraft.logging.Log;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;

public class TransactionManagementInvocationHandler
implements ServiceInvocationHandler {
    private final DatabaseConnectionContainer connectionContainer = DatabaseConnectionContainer.getInstance();
    private static final Log log = Log.getLogger(TransactionManagementInvocationHandler.class.getName());

    @Override
    public Class<? extends Annotation> annotation() {
        return TransactionManagement.class;
    }

    @Override
    public void preInvoke() {
        try {
            if (this.connectionContainer.isInTransaction()) {
                this.connectionContainer.incrementLayer();
            } else {
                Connection transactionalConnection = DataSource.getManualCommitConnection();
                this.connectionContainer.setConnection(transactionalConnection);
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    @Override
    public void postSuccessfulInvoke() {
        if (this.connectionContainer.atStartLayer()) {
            try {
                Connection conn = this.connectionContainer.getConnection();
                if (conn != null && !conn.getAutoCommit()) {
                    conn.commit();
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
        }
    }

    @Override
    public void onException(Throwable exception) {
        if (this.connectionContainer.atStartLayer()) {
            try {
                Connection conn = this.connectionContainer.getConnection();
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
                if (exception instanceof DatabaseException || exception instanceof SQLException) {
                    log.error("There was a database error with the operation. The database transaction has been rolled back", exception);
                } else {
                    log.info("There was an exception thrown from an operation. The database transaction has been rolled back", (Object)exception);
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
        }
    }

    @Override
    public void onFinal() {
        if (this.connectionContainer.atStartLayer()) {
            Connection transactionalConnection = this.connectionContainer.getConnection();
            try {
                transactionalConnection.close();
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
            this.connectionContainer.clearConnection();
        } else {
            this.connectionContainer.decrementLayer();
        }
    }
}

