/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.database;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.logging.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class UpdateQuery
extends Query {
    private final List<QueryColumn<?>> columns = new LinkedList();
    private QueryColumn<?>[] whereConditions = null;
    private String whereConditionString = null;
    private static final Log log = Log.getLogger(UpdateQuery.class.getName());

    UpdateQuery(String tableName) {
        super(tableName);
    }

    public UpdateQuery set(QueryColumn<?> ... columns) {
        Collections.addAll(this.columns, columns);
        return this;
    }

    public UpdateQuery where(QueryColumn<?> ... condition) {
        this.whereConditions = condition;
        this.whereConditionString = null;
        return this;
    }

    public UpdateQuery where(String whereConditionString) {
        this.whereConditionString = whereConditionString;
        this.whereConditions = null;
        return this;
    }

    public int execute() {
        int n;
        block8: {
            PreparedStatement s = this.buildPreparedStatement();
            try {
                n = s.executeUpdate();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    log.error("Error executing query: {}", (Object)this.queryString);
                    throw new DatabaseException(ex);
                }
            }
            s.close();
        }
        return n;
    }

    private PreparedStatement buildPreparedStatement() throws SQLException {
        this.buildQueryString();
        PreparedStatement s = this.connection().prepareStatement(this.queryString);
        AtomicInteger currentColumnNumber = new AtomicInteger(1);
        for (QueryColumn<?> column : this.columns) {
            this.setParam(s, currentColumnNumber, column);
        }
        if (this.whereConditions != null) {
            for (QueryColumn<?> queryColumn : this.whereConditions) {
                this.setParam(s, currentColumnNumber, queryColumn);
            }
        }
        return s;
    }

    private void buildQueryString() {
        String setValues = this.columns.stream().map(c -> String.format("%s = ?", c.name())).collect(Collectors.joining(", "));
        this.queryString = String.format("UPDATE %s SET %s ", this.tableName, setValues);
        if (this.whereConditions != null) {
            String whereString = Arrays.stream(this.whereConditions).map(c -> String.format("%s = ?", c.name())).collect(Collectors.joining(" AND "));
            this.queryString = this.queryString + String.format("WHERE %s", whereString);
        } else if (this.whereConditionString != null) {
            this.queryString = this.queryString + this.whereConditionString;
        }
    }
}

