/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.eventbus;

import com.equestricraft.base.eventbus.ECCancellableEvent;
import com.equestricraft.base.eventbus.ECEvent;
import com.equestricraft.base.eventbus.ECEventHandlerCache;
import com.equestricraft.base.eventbus.EventHandler;
import com.equestricraft.logging.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class ECEventBus {
    private static final ECEventBus instance = new ECEventBus();
    private final ECEventHandlerCache ecEventHandlerCache = ECEventHandlerCache.getInstance();
    private static final Log log = Log.getLogger(ECEventBus.class.getName());

    public static boolean post(ECEvent event) {
        return instance.postImpl(event);
    }

    private ECEventBus() {
    }

    private boolean postImpl(ECEvent event) {
        List<EventHandler> handlers = this.ecEventHandlerCache.getMethodsForEvent(event);
        for (EventHandler handler : handlers) {
            if (!this.shouldHandlerReceiveEvent(handler, event)) continue;
            try {
                handler.getMethod().invoke(null, event);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Throwable throwable;
                if (ex instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)ex;
                    throwable = invocationTargetException.getTargetException();
                } else {
                    throwable = ex;
                }
                ReflectiveOperationException exception = throwable;
                log.error(String.format("Error invoking method %s for event %s", handler.getMethod().getName(), event.getClass().getName()), exception);
            }
        }
        if (event instanceof ECCancellableEvent) {
            ECCancellableEvent ecCancellableEvent = (ECCancellableEvent)event;
            return ecCancellableEvent.isCancelled();
        }
        return false;
    }

    private boolean shouldHandlerReceiveEvent(EventHandler handler, ECEvent event) {
        if (handler.isShouldReceiveCancelled()) {
            return true;
        }
        if (event instanceof ECCancellableEvent) {
            ECCancellableEvent cancellableEvent = (ECCancellableEvent)event;
            return !cancellableEvent.isCancelled();
        }
        return true;
    }
}

