/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.eventbus;

import com.equestricraft.base.eventbus.ECEvent;
import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.base.eventbus.EventHandler;
import com.equestricraft.common.ListMap;
import com.equestricraft.common.ReflectionHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class ECEventHandlerCache {
    private static final ECEventHandlerCache instance = new ECEventHandlerCache();
    private final ListMap<Class<? extends ECEvent>, EventHandler> eventHandlerMap = new ListMap();

    public static ECEventHandlerCache getInstance() {
        return instance;
    }

    private ECEventHandlerCache() {
    }

    public void loadEventHandlerCache() {
        if (!this.eventHandlerMap.isEmpty()) {
            throw new IllegalStateException("Cache has already been loaded");
        }
        List<Method> methods = ReflectionHelper.scanMethodsAnnotatedWith(ECEventBusListener.class);
        for (Method method : methods) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 1 || !ECEvent.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            ECEventBusListener annotation = method.getAnnotation(ECEventBusListener.class);
            EventHandler eventHandler = new EventHandler(method, annotation.priority(), annotation.receiveCancelled());
            this.eventHandlerMap.add(method.getParameterTypes()[0], eventHandler);
        }
    }

    public List<EventHandler> getMethodsForEvent(ECEvent event) {
        Set<Class<? extends ECEvent>> allClasses = this.eventHandlerMap.getAllKeys();
        return allClasses.stream().filter(c -> event.getClass().isAssignableFrom((Class<?>)c)).flatMap(c -> this.eventHandlerMap.get((Class<? extends ECEvent>)c).stream()).sorted(Comparator.comparing(EventHandler::getPriority)).toList();
    }
}

