/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.healthcheck;

import com.equestricraft.base.healthcheck.AbstractHealthChecker;
import com.equestricraft.base.healthcheck.HealthCheckService;
import com.equestricraft.base.healthcheck.HealthCheckStatus;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.logging.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class HealthCheckController {
    private static final HealthCheckController instance = new HealthCheckController();
    private static final int HEALTH_CHECK_INTERVAL_SECONDS = 60;
    private final List<AbstractHealthChecker> healthCheckers = new LinkedList<AbstractHealthChecker>();
    private final HealthCheckService healthCheckService = HealthCheckService.getInstance();
    private final Timer updateTimer = new Timer(ThreadUtils.threadName("health-checker"));
    private static final Log log = Log.getLogger(HealthCheckController.class.getName());

    public static HealthCheckController getInstance() {
        return instance;
    }

    private HealthCheckController() {
    }

    public void init() {
        this.registerCheckers();
        this.startUpdateTask();
    }

    private void registerCheckers() {
        List<Class<AbstractHealthChecker>> checkers = ReflectionHelper.scanClassesExtendingType(AbstractHealthChecker.class);
        for (Class<AbstractHealthChecker> checker : checkers) {
            AbstractHealthChecker checkerInstance = Services.getService(checker);
            this.healthCheckers.add(checkerInstance);
            this.healthCheckService.registerHealthChecker(checkerInstance);
        }
    }

    private void startUpdateTask() {
        int millisInterval = 60000;
        this.updateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (AbstractHealthChecker checker : HealthCheckController.this.healthCheckers) {
                    HealthCheckStatus previousStatus = checker.getStatus();
                    checker.update();
                    HealthCheckStatus newStatus = checker.getStatus();
                    if (newStatus == HealthCheckStatus.BAD) {
                        log.error(String.format("Health checker %s has a is reporting a status of %s", checker.getName(), newStatus.name()));
                        continue;
                    }
                    if (newStatus != HealthCheckStatus.GOOD || previousStatus != HealthCheckStatus.BAD) continue;
                    log.info("Health checker {} is reporting a status of {}", (Object)checker.getName(), (Object)newStatus.name());
                }
            }
        }, millisInterval, (long)millisInterval);
    }
}

