/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.healthcheck;

import com.equestricraft.base.healthcheck.HealthCheckStatus;
import com.equestricraft.base.healthcheck.HealthChecker;
import java.util.LinkedList;
import java.util.List;

public final class HealthCheckService {
    private static final HealthCheckService instance = new HealthCheckService();
    private final List<HealthChecker> healthCheckers = new LinkedList<HealthChecker>();

    public static HealthCheckService getInstance() {
        return instance;
    }

    private HealthCheckService() {
    }

    void registerHealthChecker(HealthChecker healthChecker) {
        this.healthCheckers.add(healthChecker);
    }

    public List<String> getBadServices() {
        return this.healthCheckers.stream().filter(hc -> hc.getStatus() == HealthCheckStatus.BAD).map(HealthChecker::getName).toList();
    }
}

