/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.pagination;

import com.equestricraft.base.pagination.Page;
import com.equestricraft.base.pagination.SortDirection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public abstract class Pagination<T, P extends Page<T, S, F>, S, F> {
    protected final P paginate(List<T> items, int pageNumber, SortDirection sortDirection, S sortOrderObject, F filterObject) {
        Objects.requireNonNull(items, "Must provide a list of base items");
        Objects.requireNonNull(sortDirection, "Must provide a sort direction");
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be 1 or greater");
        }
        if (items.isEmpty()) {
            return this.buildPage(Collections.emptyList(), 1, 1, sortDirection, sortOrderObject, filterObject);
        }
        List<Object> filteredItems = items.stream().filter(t -> filterObject == null || this.filter(t, filterObject)).toList();
        int totalPages = Math.floorDiv(Math.max(filteredItems.size() - 1, 0), this.getMaximumPerPage()) + 1;
        pageNumber = Math.min(pageNumber, totalPages);
        List paginated = filteredItems.stream().sorted(sortDirection == SortDirection.ASCENDING ? this.compare(sortOrderObject) : this.compare(sortOrderObject).reversed()).skip((long)(pageNumber - 1) * (long)this.getMaximumPerPage()).limit(this.getMaximumPerPage()).toList();
        return this.buildPage(paginated, pageNumber, totalPages, sortDirection, sortOrderObject, filterObject);
    }

    protected abstract int getMaximumPerPage();

    protected abstract boolean filter(T var1, F var2);

    protected abstract Comparator<T> compare(S var1);

    protected abstract P buildPage(List<T> var1, int var2, int var3, SortDirection var4, S var5, F var6);
}

