/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.repository;

import com.equestricraft.base.repository.RepositoryEntity;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class LruRepositoryCache<K, T extends RepositoryEntity<K>> {
    private static final int SIZE = 500;
    private final Map<K, T> map = new LinkedHashMap<K, T>(500, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, T> eldest) {
            return this.size() > 500;
        }
    };

    public synchronized void add(T t) {
        this.map.put(t.getKey(), t);
    }

    public synchronized Optional<T> get(K key) {
        return Optional.ofNullable((RepositoryEntity)this.map.get(key));
    }

    public synchronized void remove(K key) {
        this.map.remove(key);
    }

    public synchronized void clear() {
        this.map.clear();
    }
}

