/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.repository;

import com.equestricraft.base.repository.RepositorySearchQueryFilterAction;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class MappedEqualsAction<T, V>
implements RepositorySearchQueryFilterAction<T> {
    private final Function<T, V> mappedFunction;
    private final V value;
    private final boolean not;

    MappedEqualsAction(Function<T, V> mappedFunction, V value, boolean not) {
        this.mappedFunction = mappedFunction;
        this.value = value;
        this.not = not;
    }

    @Override
    public Predicate<T> predicate() {
        Predicate<Object> predicate = this::createPredicate;
        return this.not ? predicate.negate() : predicate;
    }

    private boolean createPredicate(T t) {
        V otherValue = this.mappedFunction.apply(t);
        return Objects.equals(this.value, otherValue);
    }

    @Override
    public Stream<T> attachToStream(Stream<T> stream) {
        return stream.filter(this.predicate());
    }
}

