/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.repository;

import com.equestricraft.base.repository.LruRepositoryCache;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.base.repository.RepositorySearchQueryAction;
import com.equestricraft.base.repository.RepositorySearchQueryFilterAction;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.common.ListMap;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.MapUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Repository<T extends RepositoryEntity<K>, K>
implements Iterable<T> {
    private RepositoryDatasource<T, K> datasource = null;
    private final List<T> data = new LinkedList<T>();
    private final Map<K, T> keyLookupMap = new HashMap<K, T>();
    private final LruRepositoryCache<K, T> lruCache = new LruRepositoryCache();
    private final ListMap<Object, T> indexMap = new ListMap();
    private Function<T, Object> indexFunction = null;
    private final StampedLock lock = new StampedLock();
    private boolean hasDoneInitialLoad = false;
    private Date lastLoadTime = null;

    protected RepositoryDatasource<T, K> getDatasource() {
        return Collections::emptyList;
    }

    private RepositoryDatasource<T, K> datasource() {
        if (this.datasource == null) {
            this.datasource = this.getDatasource();
        }
        return this.datasource;
    }

    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.REPLACE;
    }

    protected Function<T, Object> getIndexFunction() {
        return null;
    }

    private Function<T, Object> indexFunction() {
        if (this.indexFunction == null) {
            this.indexFunction = this.getIndexFunction();
        }
        return this.indexFunction;
    }

    private boolean isIndexUsed() {
        return this.indexFunction() != null;
    }

    private void ensureIndexUsed() {
        if (!this.isIndexUsed()) {
            throw new IllegalStateException("Index not set up for this repository");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        this.ensureLoadIsAllowed();
        long stamp = this.lock.writeLock();
        try {
            List<T> newData = this.datasource().retrieveAll();
            this.onLoad(newData);
            if (this.updatePolicy() == RepositoryUpdatePolicy.REPLACE) {
                this.clear();
                this.data.addAll(newData);
                this.data.forEach(this::onEntityAdd);
            } else {
                for (RepositoryEntity newEntity : newData) {
                    RepositoryEntity existingEntity = (RepositoryEntity)this.keyLookupMap.get(newEntity.getKey());
                    if (existingEntity != null) {
                        this.onEntityUpdate(existingEntity, newEntity);
                        continue;
                    }
                    this.onEntityAdd(newEntity);
                    this.data.add(newEntity);
                }
            }
            this.keyLookupMap.clear();
            this.keyLookupMap.putAll(MapUtils.createMap(this.data, RepositoryEntity::getKey));
            this.rebuildIndex();
            this.hasDoneInitialLoad = true;
            this.lastLoadTime = new Date();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public final Duration getDurationSinceLastLoad() {
        return DateUtils.durationSince(this.lastLoadTime);
    }

    protected void clearRepository() {
        long stamp = this.lock.writeLock();
        try {
            this.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void clear() {
        this.data.clear();
        this.keyLookupMap.clear();
        this.indexMap.clear();
        this.lruCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(K key) {
        this.ensureLoadIsAllowed();
        long stamp = this.lock.writeLock();
        try {
            Optional<T> entityOptional = this.datasource().retrieveByKey(key);
            if (entityOptional.isPresent()) {
                RepositoryEntity entity = (RepositoryEntity)entityOptional.get();
                RepositoryEntity existing = (RepositoryEntity)this.keyLookupMap.get(key);
                if (existing != null) {
                    if (this.updatePolicy() == RepositoryUpdatePolicy.REPLACE) {
                        this.data.removeIf(d -> d.getKey().equals(key));
                        this.keyLookupMap.remove(key);
                        this.lruCache.remove(key);
                        this.data.add(entity);
                        this.keyLookupMap.put(entity.getKey(), entity);
                        this.onEntityAdd(entity);
                    } else {
                        this.onEntityUpdate(existing, entity);
                    }
                    this.rebuildIndex();
                } else {
                    this.data.add(entity);
                    this.keyLookupMap.put(entity.getKey(), entity);
                    this.onEntityAdd(entity);
                    if (this.isIndexUsed()) {
                        this.addItemToIndex(entity);
                    }
                }
            } else {
                this.data.removeIf(d -> d.getKey().equals(key));
                this.keyLookupMap.remove(key);
                this.lruCache.remove(key);
                this.rebuildIndex();
            }
            this.onLoad(this.data);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public final void rebuildIndex() {
        this.indexMap.clear();
        if (this.isIndexUsed()) {
            this.data.forEach(this::addItemToIndex);
        }
    }

    private void addItemToIndex(T t) {
        this.ensureIndexUsed();
        Object key = this.indexFunction().apply(t);
        if (key instanceof Collection) {
            Collection collection = (Collection)key;
            for (Object k : collection) {
                this.indexMap.add(k, t);
            }
        } else {
            this.indexMap.add(key, t);
        }
    }

    private void ensureLoadIsAllowed() {
        if (this.hasDoneInitialLoad && this.updatePolicy() == RepositoryUpdatePolicy.UPDATE_NOT_ALLOWED) {
            throw new IllegalStateException("An attempt was made to update a repository which does not allowed updates");
        }
    }

    protected void onLoad(List<T> data) {
    }

    protected void onEntityUpdate(T existingEntity, T newEntity) {
    }

    protected void onEntityAdd(T newEntity) {
    }

    public final T add(T t) {
        Optional<T> existing = this.findByKeyIfExists(t.getKey());
        if (existing.isPresent()) {
            return (T)((RepositoryEntity)existing.get());
        }
        this.datasource().create(t);
        return this.addToCache(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T addToCache(T t) {
        long stamp = this.lock.writeLock();
        try {
            this.data.add(t);
            this.keyLookupMap.put(t.getKey(), t);
            if (this.isIndexUsed()) {
                this.addItemToIndex(t);
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public final void add(List<T> list) {
        list = list.stream().filter(Predicate.not(this::contains)).toList();
        this.datasource().create(list);
        this.batchAddToCache(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchAddToCache(List<T> list) {
        long stamp = this.lock.writeLock();
        try {
            this.data.addAll(list);
            this.keyLookupMap.putAll(MapUtils.createMap(list, RepositoryEntity::getKey));
            if (this.isIndexUsed()) {
                list.forEach(this::addItemToIndex);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T findByKey(K key) {
        long stamp = this.lock.readLock();
        try {
            Optional<T> fromLru = this.lruCache.get(key);
            if (fromLru.isPresent()) {
                RepositoryEntity repositoryEntity = (RepositoryEntity)fromLru.get();
                return (T)repositoryEntity;
            }
            RepositoryEntity item = (RepositoryEntity)this.keyLookupMap.get(key);
            if (item != null) {
                this.lruCache.add(item);
            }
            RepositoryEntity repositoryEntity = item;
            return (T)repositoryEntity;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public final Optional<T> findByKeyIfExists(K key) {
        return Optional.ofNullable(this.findByKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> findByKeys(Collection<K> keys2) {
        long stamp = this.lock.readLock();
        try {
            List<RepositoryEntity> list = keys2.stream().map(this.keyLookupMap::get).filter(Objects::nonNull).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    @SafeVarargs
    public final List<T> findByKeys(K ... keys2) {
        return this.findByKeys((Collection<K>)Arrays.asList(keys2));
    }

    public final T findByIndexKey(Object indexKey) {
        return (T)((RepositoryEntity)this.findByIndexKeyIfExists(indexKey).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Optional<T> findByIndexKeyIfExists(Object indexKey) {
        this.ensureIndexUsed();
        long stamp = this.lock.readLock();
        try {
            Optional<T> optional = this.indexMap.getSingle(indexKey);
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> findListByIndexKey(Object indexKey) {
        this.ensureIndexUsed();
        long stamp = this.lock.readLock();
        try {
            List<T> list = this.indexMap.get(indexKey);
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> findByIndexKeys(Collection<?> indexKeys) {
        this.ensureIndexUsed();
        long stamp = this.lock.readLock();
        try {
            List list = indexKeys.stream().map(this.indexMap::get).flatMap(Collection::stream).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public final List<T> findByIndexKeys(Object ... indexKeys) {
        return this.findByIndexKeys(Arrays.asList(indexKeys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Optional<T> findSingleByPredicates(Predicate<T> predicate) {
        long stamp = this.lock.readLock();
        try {
            for (RepositoryEntity t : this.data) {
                if (!predicate.test(t)) continue;
                Optional<RepositoryEntity> optional = Optional.of(t);
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final Optional<T> findSingleByPredicates(Predicate<T> ... predicates) {
        long stamp = this.lock.readLock();
        try {
            Stream stream = this.data.stream();
            for (Predicate<T> predicate : predicates) {
                stream = stream.filter(predicate);
            }
            Optional optional = stream.findAny();
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> findListByPredicates(Predicate<T> predicate) {
        LinkedList<RepositoryEntity> newList = new LinkedList<RepositoryEntity>();
        long stamp = this.lock.readLock();
        try {
            for (RepositoryEntity t : this.data) {
                if (!predicate.test(t)) continue;
                newList.add(t);
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final List<T> findListByPredicates(Predicate<T> ... predicates) {
        long stamp = this.lock.readLock();
        try {
            Stream stream = this.data.stream();
            for (Predicate<T> predicate : predicates) {
                stream = stream.filter(predicate);
            }
            List list = stream.toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    protected final RepositorySearchQuery<T> createSearchQuery() {
        return new RepositorySearchQuery(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<T> executeManySearch(RepositorySearchQuery<T> repositorySearchQuery) {
        long stamp = this.lock.readLock();
        try {
            List<Object> toReturn;
            if (repositorySearchQuery.isSimple()) {
                toReturn = new LinkedList();
                List<RepositorySearchQueryFilterAction<T>> simpleActions = this.extractSimpleActions(repositorySearchQuery);
                for (RepositoryEntity t : this.data) {
                    if (!this.doAllSimpleActionsPass(t, simpleActions)) continue;
                    toReturn.add(t);
                }
            } else {
                Stream stream = this.createStreamWithSearchActions(repositorySearchQuery.getRepositorySearchActions());
                toReturn = stream.collect(Collectors.toList());
            }
            List<Object> list = toReturn;
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<T> executeSingleSearch(RepositorySearchQuery<T> repositorySearchQuery) {
        long stamp = this.lock.readLock();
        try {
            if (repositorySearchQuery.isSimple()) {
                List<RepositorySearchQueryFilterAction<T>> simpleActions = this.extractSimpleActions(repositorySearchQuery);
                for (RepositoryEntity t : this.data) {
                    if (!this.doAllSimpleActionsPass(t, simpleActions)) continue;
                    Optional<RepositoryEntity> optional = Optional.of(t);
                    return optional;
                }
                Optional optional = Optional.empty();
                return optional;
            }
            Stream<T> stream = this.createStreamWithSearchActions(repositorySearchQuery.getRepositorySearchActions());
            Optional<T> optional = stream.findAny();
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long executeCount(RepositorySearchQuery<T> repositorySearchQuery) {
        long stamp = this.lock.readLock();
        try {
            long count;
            if (repositorySearchQuery.isSimple()) {
                count = 0L;
                List<RepositorySearchQueryFilterAction<T>> simpleActions = this.extractSimpleActions(repositorySearchQuery);
                for (RepositoryEntity t : this.data) {
                    if (!this.doAllSimpleActionsPass(t, simpleActions)) continue;
                    ++count;
                }
            } else {
                Stream<T> stream = this.createStreamWithSearchActions(repositorySearchQuery.getRepositorySearchActions());
                count = stream.count();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private List<RepositorySearchQueryFilterAction<T>> extractSimpleActions(RepositorySearchQuery<T> repositorySearchQuery) {
        LinkedList<RepositorySearchQueryFilterAction<T>> simpleActions = new LinkedList<RepositorySearchQueryFilterAction<T>>();
        for (RepositorySearchQueryAction<T> searchQueryAction : repositorySearchQuery.getRepositorySearchActions()) {
            if (!(searchQueryAction instanceof RepositorySearchQueryFilterAction)) continue;
            simpleActions.add((RepositorySearchQueryFilterAction)searchQueryAction);
        }
        return simpleActions;
    }

    private boolean doAllSimpleActionsPass(T t, List<RepositorySearchQueryFilterAction<T>> filterActions) {
        for (RepositorySearchQueryFilterAction<T> simpleAction : filterActions) {
            if (simpleAction.predicate().test(t)) continue;
            return false;
        }
        return true;
    }

    private Stream<T> createStreamWithSearchActions(List<RepositorySearchQueryAction<T>> repositorySearchQueryActions) {
        Stream<Object> stream = this.data.stream();
        for (RepositorySearchQueryAction repositorySearchQueryAction : repositorySearchQueryActions) {
            stream = repositorySearchQueryAction.attachToStream(stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> findAll() {
        long stamp = this.lock.readLock();
        try {
            List<T> list = ListUtils.listCopy(this.data);
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public final boolean contains(T t) {
        return this.contains((K)t.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(K k) {
        long stamp = this.lock.readLock();
        try {
            boolean bl = this.keyLookupMap.containsKey(k);
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public final void update(T t) {
        this.datasource().update(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeByPredicate(Predicate<T> predicate) {
        List<RepositoryEntity> toRemove = this.findListByPredicates(predicate);
        long stamp = this.lock.writeLock();
        try {
            this.data.removeIf(predicate);
            toRemove.forEach(item -> {
                this.keyLookupMap.remove(item.getKey());
                this.lruCache.remove(item.getKey());
            });
            this.rebuildIndex();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public final boolean remove(T t) {
        return this.removeByKey(t.getKey());
    }

    public final boolean removeByKey(K key) {
        this.datasource().deleteByKey(key);
        return this.removeFromCacheByKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromCacheByKey(K k) {
        Optional<T> item = this.findByKeyIfExists(k);
        long stamp = this.lock.writeLock();
        try {
            if (item.isPresent()) {
                this.data.removeIf(t -> t.getKey().equals(k));
                this.keyLookupMap.remove(k);
                this.lruCache.remove(k);
                this.rebuildIndex();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTotalSize() {
        long stamp = this.lock.readLock();
        try {
            int n = this.data.size();
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    @Override
    public final Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    public final Stream<T> streamAll() {
        return this.findAll().stream();
    }
}

