/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.repository;

import com.equestricraft.base.repository.RepositoryEntity;
import java.util.List;
import java.util.Optional;

public interface RepositoryDatasource<T extends RepositoryEntity<K>, K> {
    default public void create(T t) {
    }

    default public void create(List<T> list) {
        list.forEach(this::create);
    }

    default public Optional<T> retrieveByKey(K key) {
        List<T> all = this.retrieveAll();
        return all.stream().filter(e -> e.getKey().equals(key)).findFirst();
    }

    public List<T> retrieveAll();

    default public void update(T t) {
    }

    default public void deleteByKey(K k) {
    }
}

