/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.repository;

import com.equestricraft.base.repository.DistinctAction;
import com.equestricraft.base.repository.FilterAction;
import com.equestricraft.base.repository.LimitAction;
import com.equestricraft.base.repository.MappedEqualsAction;
import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.base.repository.RepositorySearchQueryAction;
import com.equestricraft.base.repository.SkipAction;
import com.equestricraft.base.repository.SortAction;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class RepositorySearchQuery<T extends RepositoryEntity<?>> {
    private final Repository<T, ?> repository;
    private final List<RepositorySearchQueryAction<T>> repositorySearchQueryActions = new LinkedList<RepositorySearchQueryAction<T>>();
    private boolean simple = true;

    RepositorySearchQuery(Repository<T, ?> repository) {
        this.repository = repository;
    }

    public RepositorySearchQuery<T> filter(Predicate<T> predicate) {
        this.repositorySearchQueryActions.add(new FilterAction<T>(predicate, false));
        return this;
    }

    public RepositorySearchQuery<T> filterType(Class<? extends T> type) {
        return this.filter(type::isInstance);
    }

    public RepositorySearchQuery<T> filterNot(Predicate<T> predicate) {
        this.repositorySearchQueryActions.add(new FilterAction<T>(predicate, true));
        return this;
    }

    public RepositorySearchQuery<T> filterNotType(Class<? extends T> type) {
        return this.filterNot(type::isInstance);
    }

    public <V> RepositorySearchQuery<T> mappedEquals(Function<T, V> mappedFunction, V value) {
        this.repositorySearchQueryActions.add(new MappedEqualsAction<T, V>(mappedFunction, value, false));
        return this;
    }

    public <V> RepositorySearchQuery<T> mappedEqualsNot(Function<T, V> mappedFunction, V value) {
        this.repositorySearchQueryActions.add(new MappedEqualsAction<T, V>(mappedFunction, value, true));
        return this;
    }

    public RepositorySearchQuery<T> mappedNull(Function<T, Object> mappedFunction) {
        return this.mappedEquals(mappedFunction, null);
    }

    public RepositorySearchQuery<T> mappedNotNull(Function<T, Object> mappedFunction) {
        return this.mappedEqualsNot(mappedFunction, null);
    }

    public RepositorySearchQuery<T> sort(Comparator<T> comparator) {
        this.repositorySearchQueryActions.add(new SortAction<T>(comparator, false));
        this.simple = false;
        return this;
    }

    public RepositorySearchQuery<T> sortReverse(Comparator<T> comparator) {
        this.repositorySearchQueryActions.add(new SortAction<T>(comparator, true));
        this.simple = false;
        return this;
    }

    public RepositorySearchQuery<T> sort(ToIntFunction<T> keyExtractor) {
        return this.sort(Comparator.comparingInt(keyExtractor));
    }

    public RepositorySearchQuery<T> sortReverse(ToIntFunction<T> keyExtractor) {
        return this.sortReverse(Comparator.comparingInt(keyExtractor));
    }

    public RepositorySearchQuery<T> sort(ToLongFunction<T> keyExtractor) {
        return this.sort(Comparator.comparingLong(keyExtractor));
    }

    public RepositorySearchQuery<T> sortReverse(ToLongFunction<T> keyExtractor) {
        return this.sortReverse(Comparator.comparingLong(keyExtractor));
    }

    public RepositorySearchQuery<T> distinct() {
        this.repositorySearchQueryActions.add(new DistinctAction());
        this.simple = false;
        return this;
    }

    public RepositorySearchQuery<T> skip(long amount) {
        this.repositorySearchQueryActions.add(new SkipAction(amount));
        this.simple = false;
        return this;
    }

    public RepositorySearchQuery<T> limit(long amount) {
        this.repositorySearchQueryActions.add(new LimitAction(amount));
        this.simple = false;
        return this;
    }

    List<RepositorySearchQueryAction<T>> getRepositorySearchActions() {
        return this.repositorySearchQueryActions;
    }

    boolean isSimple() {
        return this.simple;
    }

    public List<T> many() {
        return this.repository.executeManySearch(this);
    }

    public <R> List<R> mappedMany(Function<T, R> mapper) {
        return this.many().stream().map(mapper).toList();
    }

    public <R extends T> List<R> castedMany(Class<? extends R> castType) {
        return this.mappedMany(castType::cast);
    }

    public Optional<T> single() {
        return this.repository.executeSingleSearch(this);
    }

    public <R> Optional<R> mappedSingle(Function<T, R> mapper) {
        return this.single().map(mapper);
    }

    public <R extends T> Optional<R> castedSingle(Class<? extends R> castType) {
        return this.mappedSingle(castType::cast);
    }

    public long count() {
        return this.repository.executeCount(this);
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

