/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.response;

import com.equestricraft.base.response.BasicResponse;
import com.equestricraft.base.response.ComplexResponse;
import com.equestricraft.base.response.EmptyResponse;
import com.equestricraft.base.response.PromptResponse;
import com.equestricraft.base.response.Response;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class ResponseBuilder {
    private boolean success = true;
    private String title = null;
    private Supplier<Object> onOkAction = null;
    private final List<String> messages = new LinkedList<String>();

    protected ResponseBuilder() {
    }

    public ResponseBuilder withSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public ResponseBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public ResponseBuilder withOnOkAction(Runnable onOkAction) {
        return this.withOnOkAction(() -> {
            onOkAction.run();
            return null;
        });
    }

    public ResponseBuilder withOnOkAction(Supplier<Object> onOkAction) {
        this.onOkAction = onOkAction;
        return this;
    }

    public ResponseBuilder withMessage(String message) {
        Objects.requireNonNull(message, "Must supply a message");
        this.messages.add(message);
        return this;
    }

    public Response build() {
        if (this.messages.isEmpty()) {
            return new EmptyResponse(this.success);
        }
        if (this.messages.size() == 1) {
            if (this.title == null) {
                return new BasicResponse(this.success, this.messages.get(0));
            }
            return new PromptResponse(this.success, this.title, this.messages.get(0), this.onOkAction);
        }
        return new ComplexResponse(this.success, this.messages);
    }
}

