/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.response;

import com.equestricraft.base.response.BasicResponse;
import com.equestricraft.base.response.EmptyResponse;
import com.equestricraft.base.response.FutureResponse;
import com.equestricraft.base.response.PromptResponse;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseBuilder;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class ResponseFactory {
    private static final String ERROR_MUST_SUPPLY_TITLE = "Must supply a title";
    private static final String ERROR_MUST_SUPPLY_MESSAGE = "Must supply a message";
    private static final String ERROR_MUST_SUPPLY_EXCEPTION = "Must supply an exception";

    public static Response success() {
        return new EmptyResponse(true);
    }

    public static Response fail() {
        return new EmptyResponse(false);
    }

    public static Response success(String message) {
        Objects.requireNonNull(message, ERROR_MUST_SUPPLY_MESSAGE);
        return new BasicResponse(true, message);
    }

    public static Response success(String title, String message) {
        return ResponseFactory.success(title, message, (Runnable)null);
    }

    public static Response success(String title, String message, Runnable onOk) {
        return ResponseFactory.success(title, message, () -> {
            if (onOk != null) {
                onOk.run();
            }
            return null;
        });
    }

    public static Response success(String title, String message, Supplier<Object> onOk) {
        Objects.requireNonNull(title, ERROR_MUST_SUPPLY_TITLE);
        Objects.requireNonNull(message, ERROR_MUST_SUPPLY_MESSAGE);
        return new PromptResponse(true, title, message, onOk);
    }

    public static Response fail(String message) {
        Objects.requireNonNull(message, ERROR_MUST_SUPPLY_MESSAGE);
        return new BasicResponse(false, message);
    }

    public static Response fail(String title, String message) {
        return ResponseFactory.fail(title, message, (Runnable)null);
    }

    public static Response fail(String title, String message, Runnable onOk) {
        return ResponseFactory.fail(title, message, () -> {
            if (onOk != null) {
                onOk.run();
            }
            return null;
        });
    }

    public static Response fail(String title, String message, Supplier<Object> onOk) {
        Objects.requireNonNull(title, ERROR_MUST_SUPPLY_TITLE);
        Objects.requireNonNull(message, ERROR_MUST_SUPPLY_MESSAGE);
        return new PromptResponse(false, title, message, onOk);
    }

    public static Response fail(Exception exception) {
        Objects.requireNonNull(exception, ERROR_MUST_SUPPLY_EXCEPTION);
        return ResponseFactory.fail(exception.getMessage());
    }

    public static Response fail(String title, Exception exception) {
        return ResponseFactory.fail(title, exception, (Runnable)null);
    }

    public static Response fail(String title, Exception exception, Runnable onOk) {
        Objects.requireNonNull(title, ERROR_MUST_SUPPLY_TITLE);
        Objects.requireNonNull(exception, ERROR_MUST_SUPPLY_EXCEPTION);
        return ResponseFactory.fail(title, exception.getMessage(), onOk);
    }

    public static Response fail(String title, Exception exception, Supplier<Object> onOk) {
        Objects.requireNonNull(title, ERROR_MUST_SUPPLY_TITLE);
        Objects.requireNonNull(exception, ERROR_MUST_SUPPLY_EXCEPTION);
        return ResponseFactory.fail(title, exception.getMessage(), onOk);
    }

    public static Response future(CompletableFuture<Response> future) {
        return new FutureResponse(future);
    }

    public static ResponseBuilder startResponse() {
        return new ResponseBuilder();
    }

    private ResponseFactory() {
    }
}

