/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.response;

import com.equestricraft.api.common.APIResponse;
import com.equestricraft.base.response.BasicResponse;
import com.equestricraft.base.response.EmptyResponse;
import com.equestricraft.base.response.Response;

public class ResponseTransformer {
    public APIResponse toApiResponse(Response response) {
        if (response instanceof EmptyResponse) {
            EmptyResponse emptyResponse = (EmptyResponse)response;
            return ResponseTransformer.toApiResponse(emptyResponse);
        }
        if (response instanceof BasicResponse) {
            BasicResponse basicResponse = (BasicResponse)response;
            return ResponseTransformer.toApiResponse(basicResponse);
        }
        throw new IllegalArgumentException(String.format("Invalid response: %s", response.getClass().getName()));
    }

    private static APIResponse toApiResponse(EmptyResponse emptyResponse) {
        return new APIResponse(emptyResponse.isSuccess(), null);
    }

    private static APIResponse toApiResponse(BasicResponse basicResponse) {
        return new APIResponse(basicResponse.isSuccess(), basicResponse.getMessage());
    }
}

