/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.task;

import com.equestricraft.base.task.SchedulerTask;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class TaskScheduler {
    private static TaskScheduler taskScheduler = null;

    public static void setAsyncTaskScheduler(TaskScheduler taskScheduler) {
        TaskScheduler.taskScheduler = taskScheduler;
    }

    public static SchedulerTask executeSyncTask(Runnable runnable2) {
        Objects.requireNonNull(runnable2, "Must supply a runnable");
        return taskScheduler.runSyncTask(runnable2);
    }

    public static SchedulerTask executeSyncTask(Runnable runnable2, Duration delay) {
        Objects.requireNonNull(runnable2, "Must supply a runnable");
        return taskScheduler.runSyncTask(runnable2, delay);
    }

    public static SchedulerTask executeSyncTask(Runnable runnable2, Duration delay, Duration period) {
        Objects.requireNonNull(runnable2, "Must supply a runnable");
        return taskScheduler.runSyncTask(runnable2, delay, period);
    }

    public static void executeAwaitSyncTask(Runnable task) {
        Objects.requireNonNull(task, "Must supply a runnable");
        taskScheduler.awaitSyncTask(task);
    }

    public static <T> T executeAwaitSyncTask(Supplier<T> task) {
        Objects.requireNonNull(task, "Must supply a runnable");
        return taskScheduler.awaitSyncTask(task);
    }

    public static SchedulerTask executeAsyncTask(Runnable runnable2) {
        Objects.requireNonNull(runnable2, "Must supply a runnable");
        return taskScheduler.runAsyncTask(runnable2);
    }

    public static SchedulerTask executeAsyncTask(Runnable runnable2, Duration delay) {
        Objects.requireNonNull(runnable2, "Must supply a runnable");
        return taskScheduler.runAsyncTask(runnable2, delay);
    }

    public static SchedulerTask executeAsyncTask(Runnable runnable2, Duration delay, Duration period) {
        Objects.requireNonNull(runnable2, "Must supply a runnable");
        return taskScheduler.runAsyncTask(runnable2, delay, period);
    }

    protected abstract SchedulerTask runSyncTask(Runnable var1);

    protected abstract SchedulerTask runSyncTask(Runnable var1, Duration var2);

    protected abstract SchedulerTask runSyncTask(Runnable var1, Duration var2, Duration var3);

    protected abstract void awaitSyncTask(Runnable var1);

    protected abstract <T> T awaitSyncTask(Supplier<T> var1);

    protected abstract SchedulerTask runAsyncTask(Runnable var1);

    protected abstract SchedulerTask runAsyncTask(Runnable var1, Duration var2);

    protected abstract SchedulerTask runAsyncTask(Runnable var1, Duration var2, Duration var3);
}

