/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.text;

import com.equestricraft.common.Argb;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TextItem {
    private String text;
    private Argb color = Argb.ARGB_WHITE;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private boolean strikethrough = false;
    private TextItem hoverItem;
    private final List<TextItem> childItems = new ArrayList<TextItem>(0);

    public TextItem() {
    }

    public TextItem(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Argb getColor() {
        return this.color;
    }

    public void setColor(Argb color) {
        this.color = Objects.requireNonNull(color, "Must supply a color");
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public TextItem getHoverItem() {
        return this.hoverItem;
    }

    public void setHoverItem(TextItem hoverItem) {
        this.hoverItem = hoverItem;
    }

    public List<TextItem> getChildItems() {
        return this.childItems;
    }

    public void addChildItem(TextItem textItem) {
        this.childItems.add(textItem);
    }

    public String toString() {
        if (this.childItems.isEmpty()) {
            return this.getText();
        }
        return this.childItems.stream().map(TextItem::toString).collect(Collectors.joining());
    }
}

