/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.thread;

import com.equestricraft.base.thread.ServerThreadException;
import com.equestricraft.logging.Log;

public class ThreadChecker {
    private static final String SERVER_THREAD_NAME = "Server thread";
    private static boolean reportServerThreadWarnings = false;
    private static final Log log = Log.getLogger(ThreadChecker.class.getName());

    public static void setReportServerThreadWarnings(boolean set2) {
        reportServerThreadWarnings = set2;
    }

    public static void warnIfServerThread(String message) {
        if (reportServerThreadWarnings && ThreadChecker.isServerThread()) {
            ServerThreadException ex = new ServerThreadException(message);
            log.error(message, ex);
        }
    }

    public static boolean isServerThread() {
        return Thread.currentThread().getName().equals(SERVER_THREAD_NAME);
    }

    public static void ensureNotServerThread() {
        if (ThreadChecker.isServerThread()) {
            throw new ServerThreadException("Cannot execute on server thread");
        }
    }

    public static void ensureServerThread() {
        if (!ThreadChecker.isServerThread()) {
            throw new ServerThreadException("Must execute on server thread");
        }
    }

    private ThreadChecker() {
    }
}

