/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.base.worldarea;

import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.Range;
import com.equestricraft.common.coordinate.GeometryUtil;
import java.awt.geom.Path2D;

public class WorldAreaUtil {
    public static WorldArea toWorldArea(String worldAreaString) {
        String[] worldAreaStringArr = worldAreaString.split("\\|");
        String geometryString = worldAreaStringArr[0];
        String yLevelString = worldAreaStringArr[1];
        String dimensionString = worldAreaStringArr[2];
        Path2D path2D = geometryString.isEmpty() ? new Path2D.Double() : GeometryUtil.buildPathFromGeometryString(geometryString);
        String[] yLevelArr = yLevelString.split(",");
        int lowerY = Integer.parseInt(yLevelArr[0]);
        int upperY = Integer.parseInt(yLevelArr[1]);
        Range<Integer> yRange = Range.of(lowerY, upperY);
        ECLevel ecLevel = ECLevel.getByIdentifier(dimensionString);
        return new WorldArea(path2D, yRange, ecLevel);
    }

    private WorldAreaUtil() {
    }
}

