/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.cdi;

import com.equestricraft.cdi.ServiceInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ECInvocationHandler
implements InvocationHandler {
    private final Object target;
    private final List<ServiceInvocationHandler> invocationHandlerList;

    public ECInvocationHandler(Object target, List<ServiceInvocationHandler> invocationHandlerList) {
        this.target = target;
        this.invocationHandlerList = invocationHandlerList;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        this.executePreInvokeActions();
        try {
            Object response = method.invoke(this.target, args2);
            this.executePostSuccessfulInvokeActions();
            Object object = response;
            return object;
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            this.executeOnExceptionActions(targetException);
            throw targetException;
        }
        finally {
            this.executeOnFinalActions();
        }
    }

    private void executePreInvokeActions() {
        for (ServiceInvocationHandler serviceInvocationHandler : this.invocationHandlerList) {
            serviceInvocationHandler.preInvoke();
        }
    }

    private void executePostSuccessfulInvokeActions() {
        for (ServiceInvocationHandler serviceInvocationHandler : this.invocationHandlerList) {
            serviceInvocationHandler.postSuccessfulInvoke();
        }
    }

    private void executeOnExceptionActions(Throwable throwable) {
        for (ServiceInvocationHandler serviceInvocationHandler : this.invocationHandlerList) {
            serviceInvocationHandler.onException(throwable);
        }
    }

    private void executeOnFinalActions() {
        for (ServiceInvocationHandler serviceInvocationHandler : this.invocationHandlerList) {
            serviceInvocationHandler.onFinal();
        }
    }
}

