/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.cdi;

import com.equestricraft.cdi.Produced;
import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceException;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class ServiceInit {
    private ServiceInit() {
    }

    public static void initServices() {
        try {
            ServiceInit.executeProducers();
            ServiceInit.injectFields();
        }
        catch (IllegalAccessException ex) {
            throw new ServiceException(ex);
        }
    }

    private static void executeProducers() throws IllegalAccessException {
        List<Method> producers = ReflectionHelper.scanMethodsAnnotatedWith(Produced.class);
        for (Method producer : producers) {
            Class<?> clazz = producer.getDeclaringClass();
            Object service = Services.getService(clazz);
            try {
                Object value = producer.invoke(service, new Object[0]);
                Services.provideService(value);
            }
            catch (InvocationTargetException ex) {
                throw new ServiceException(ex);
            }
        }
    }

    private static void injectFields() throws IllegalAccessException {
        List<Field> fields = ReflectionHelper.scanFieldsAnnotatedWith(Service.class);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) {
                ServiceInit.injectStaticField(field);
                continue;
            }
            ServiceInit.injectConcreteField(field);
        }
    }

    private static void injectStaticField(Field field) throws IllegalAccessException {
        boolean isPrivate;
        boolean bl = isPrivate = !field.canAccess(null);
        if (isPrivate) {
            field.setAccessible(true);
        }
        field.set(null, ServiceInit.getServiceForField(field));
        if (isPrivate) {
            field.setAccessible(false);
        }
    }

    private static void injectConcreteField(Field field) throws IllegalAccessException {
        boolean isPrivate;
        Object fieldClass = Services.getService(field.getDeclaringClass());
        boolean bl = isPrivate = !field.canAccess(fieldClass);
        if (isPrivate) {
            field.setAccessible(true);
        }
        field.set(fieldClass, ServiceInit.getServiceForField(field));
        if (isPrivate) {
            field.setAccessible(false);
        }
    }

    private static Object getServiceForField(Field field) {
        Class<?> fieldType = field.getType();
        if (field.getType() == ServiceInstance.class) {
            ParameterizedType parameterizedType;
            Type[] typeArguments;
            Type type;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType && (type = (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments())[0]) instanceof Class) {
                Class clazz = (Class)type;
                List implementations = Services.getServiceImplementations(clazz);
                return new ServiceInstance<Object>(implementations.toArray());
            }
            throw new ServiceException("Invalid ServiceInstance declaration");
        }
        return Services.getService(fieldType);
    }
}

