/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.cdi;

import com.equestricraft.common.UnmodifiableCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ServiceInstance<T>
implements UnmodifiableCollection<T> {
    private final T[] instances;

    ServiceInstance(T[] instances) {
        this.instances = instances;
    }

    public T get() {
        return this.instances[0];
    }

    @Override
    public int size() {
        return this.instances.length;
    }

    @Override
    public boolean contains(Object o) {
        for (T instance : this.instances) {
            if (instance != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new ServiceInstanceIterator();
    }

    @Override
    public Object[] toArray() {
        return this.instances;
    }

    private class ServiceInstanceIterator
    implements Iterator<T> {
        private int currentIndex = 0;

        private ServiceInstanceIterator() {
        }

        @Override
        public boolean hasNext() {
            return ServiceInstance.this.instances.length > this.currentIndex;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return ServiceInstance.this.instances[this.currentIndex++];
            }
            throw new NoSuchElementException();
        }
    }
}

