/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.cdi;

import com.equestricraft.cdi.ECInvocationHandler;
import com.equestricraft.cdi.ServiceException;
import com.equestricraft.cdi.ServiceIgnore;
import com.equestricraft.cdi.ServiceInvocationHandler;
import com.equestricraft.common.ListMap;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;

public class Services {
    private static final ListMap<Class<?>, Object> servicesMap = new ListMap();
    private static final StampedLock LOCK = new StampedLock();
    private static final boolean FAIL_LAZY_MODE = Boolean.parseBoolean(System.getenv("EC_SERVICE_LOOKUP_FAIL_LAZY"));
    private static final List<ServiceInvocationHandler> SERVICE_INVOCATION_HANDLERS = new LinkedList<ServiceInvocationHandler>();
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E, I extends E> List<E> createService(Class<E> type) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Object> instances = new ArrayList<Object>(1);
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            List<Class<E>> impls = type.isInterface() ? ReflectionHelper.scanClassesImplementingType(type) : ReflectionHelper.scanClassesExtendingType(type);
            for (Class<E> impl : impls) {
                if (impl.isAnnotationPresent(ServiceIgnore.class)) continue;
                E e = Services.getService(impl);
                List<ServiceInvocationHandler> serviceInvocationHandlers = Services.getInvocationHandlersForClass(impl);
                if (ListUtils.isNotEmpty(serviceInvocationHandlers)) {
                    ECInvocationHandler ecInvocationHandler = new ECInvocationHandler(e, serviceInvocationHandlers);
                    Object instance = Proxy.newProxyInstance(e.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)ecInvocationHandler);
                    instances.add(instance);
                    continue;
                }
                instances.add(e);
            }
        } else {
            instances.add(type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        long stamp = LOCK.writeLock();
        try {
            for (Object e : instances) {
                servicesMap.add(type, e);
            }
        }
        finally {
            LOCK.unlockWrite(stamp);
        }
        return instances;
    }

    public static <E> E getService(Class<E> type) {
        List<E> implementations = Services.getServiceImplementations(type);
        if (implementations.isEmpty()) {
            throw new ServiceException("Implementation not found for class " + type.getName());
        }
        return implementations.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <E> List<E> getServiceImplementations(Class<E> type) {
        long stamp = LOCK.readLock();
        try {
            List<Object> items;
            if (servicesMap.has(type) && !(items = servicesMap.get(type)).isEmpty()) {
                List<Object> list = servicesMap.get(type);
                return list;
            }
        }
        finally {
            LOCK.unlockRead(stamp);
        }
        try {
            return Services.createService(type);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            if (FAIL_LAZY_MODE) {
                log.info("Implementation for service class {} was not found, but fail silent mode is enabled so null will be returned", (Object)type.getName());
                return Collections.singletonList(Services.createDummyImplementation(type));
            }
            log.error("Error creating service " + type.getName(), ex);
            throw new ServiceException("Error creating service " + type.getName(), ex);
        }
    }

    private static <E> E createDummyImplementation(Class<E> type) {
        return (E)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (proxy, method, args2) -> {
            throw new UnsupportedOperationException("This service class has no implementation");
        });
    }

    private static List<ServiceInvocationHandler> getInvocationHandlersForClass(Class<?> clazz) {
        LinkedList<ServiceInvocationHandler> classList = new LinkedList<ServiceInvocationHandler>();
        for (Annotation annotation : clazz.getAnnotations()) {
            Services.findInvocationHandlerByAnnotation(annotation.annotationType()).ifPresent(classList::add);
        }
        return classList;
    }

    private static Optional<ServiceInvocationHandler> findInvocationHandlerByAnnotation(Class<? extends Annotation> annotation) {
        return SERVICE_INVOCATION_HANDLERS.stream().filter(c -> c.annotation().equals(annotation)).findAny();
    }

    static <T> void provideService(T t) {
        long stamp = LOCK.writeLock();
        try {
            servicesMap.add(t.getClass(), t);
        }
        finally {
            LOCK.unlockWrite(stamp);
        }
    }

    private Services() {
    }

    static {
        List<Class<ServiceInvocationHandler>> classes = ReflectionHelper.scanClassesImplementingType(ServiceInvocationHandler.class);
        try {
            for (Class<ServiceInvocationHandler> clazz : classes) {
                ServiceInvocationHandler serviceInvocationHandler = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                SERVICE_INVOCATION_HANDLERS.add(serviceInvocationHandler);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ServiceException("Error creating service invocation handlers", ex);
        }
        log = Log.getLogger(Services.class.getName());
    }
}

