/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.Range;
import com.equestricraft.common.util.NumberUtils;

public record Argb(int alpha, int red, int green, int blue) {
    private static final Range<Integer> valueValidRange = Range.of(0, 255);
    public static final Argb ARGB_WHITE = new Argb(255, 255, 255, 255);
    public static final Argb ARGB_RED = new Argb(255, 255, 0, 0);
    public static final Argb ARGB_YELLOW = new Argb(255, 255, 255, 0);
    public static final Argb ARGB_GREEN = new Argb(255, 0, 255, 0);
    public static final Argb ARGB_AQUA = new Argb(255, 0, 255, 255);
    public static final Argb ARGB_BLUE = new Argb(255, 0, 0, 255);
    public static final Argb ARGB_PINK = new Argb(255, 255, 0, 255);
    public static final Argb ARGB_BLACK = new Argb(255, 0, 0, 0);
    public static final Argb ARGB_MC_BLACK = new Argb(255, 0, 0, 0);
    public static final Argb ARGB_MC_DARK_BLUE = new Argb(255, 0, 0, 170);
    public static final Argb ARGB_MC_DARK_GREEN = new Argb(255, 0, 170, 0);
    public static final Argb ARGB_MC_DARK_AQUA = new Argb(255, 0, 170, 170);
    public static final Argb ARGB_MC_DARK_RED = new Argb(255, 170, 0, 0);
    public static final Argb ARGB_MC_DARK_PURPLE = new Argb(255, 170, 0, 170);
    public static final Argb ARGB_MC_GOLD = new Argb(255, 255, 170, 0);
    public static final Argb ARGB_MC_GRAY = new Argb(255, 170, 170, 170);
    public static final Argb ARGB_MC_DARK_GRAY = new Argb(255, 85, 85, 85);
    public static final Argb ARGB_MC_BLUE = new Argb(255, 85, 85, 255);
    public static final Argb ARGB_MC_GREEN = new Argb(255, 85, 255, 85);
    public static final Argb ARGB_MC_AQUA = new Argb(255, 85, 255, 255);
    public static final Argb ARGB_MC_RED = new Argb(255, 255, 85, 85);
    public static final Argb ARGB_MC_LIGHT_PURPLE = new Argb(255, 255, 85, 255);
    public static final Argb ARGB_MC_YELLOW = new Argb(255, 255, 255, 85);
    public static final Argb ARGB_MC_WHITE = new Argb(255, 255, 255, 255);

    public Argb {
        if (!valueValidRange.containsValueWithin(alpha)) {
            throw new IllegalArgumentException("Alpha value must be in the range 0-255");
        }
        if (!valueValidRange.containsValueWithin(red)) {
            throw new IllegalArgumentException("Red value must be in the range 0-255");
        }
        if (!valueValidRange.containsValueWithin(green)) {
            throw new IllegalArgumentException("Green value must be in the range 0-255");
        }
        if (!valueValidRange.containsValueWithin(blue)) {
            throw new IllegalArgumentException("Blue value must be in the range 0-255");
        }
    }

    public Argb withTransparency(int transparency) {
        return new Argb(transparency, this.red, this.green, this.blue);
    }

    public int getIntValue() {
        return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
    }

    public String getHexValue() {
        int color = this.getIntValue();
        return String.format("#%06X", color & 0xFFFFFF);
    }

    public Argb invert() {
        return new Argb(this.alpha, this.blue, this.green, this.red);
    }

    public static Argb blend(Argb argb1, Argb argb2) {
        return new Argb(NumberUtils.average(argb1.alpha(), argb2.alpha()), NumberUtils.average(argb1.red(), argb2.red()), NumberUtils.average(argb1.green(), argb2.green()), NumberUtils.average(argb1.blue(), argb2.blue()));
    }

    public static Argb fromIntValue(int value) {
        int alpha = value >> 24 & 0xFF;
        int red = value >> 16 & 0xFF;
        int green = value >> 8 & 0xFF;
        int blue = value & 0xFF;
        return new Argb(alpha, red, green, blue);
    }

    public static Argb fromHexString(String hex) {
        int blue;
        int green;
        int red;
        int alpha;
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6 && hex.length() != 8) {
            throw new IllegalArgumentException("Hex string must be in the format #RRGGBB or #AARRGGBB");
        }
        if (hex.length() == 6) {
            alpha = 255;
            red = Integer.parseInt(hex.substring(0, 2), 16);
            green = Integer.parseInt(hex.substring(2, 4), 16);
            blue = Integer.parseInt(hex.substring(4, 6), 16);
        } else {
            alpha = Integer.parseInt(hex.substring(0, 2), 16);
            red = Integer.parseInt(hex.substring(2, 4), 16);
            green = Integer.parseInt(hex.substring(4, 6), 16);
            blue = Integer.parseInt(hex.substring(6, 8), 16);
        }
        return new Argb(alpha, red, green, blue);
    }
}

