/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.logging.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AsciiArt {
    private static final Log log = Log.getLogger(AsciiArt.class.getName());

    public static String getAsciiFromFile() {
        String string;
        InputStream inputStream2 = AsciiArt.class.getResourceAsStream("/ascii-art.txt");
        if (inputStream2 == null) {
            return "ascii-art.txt does not exist :(";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));
        try {
            String line;
            Stream.Builder<String> builder = Stream.builder();
            while ((line = reader.readLine()) != null) {
                builder.accept(line);
            }
            string = builder.build().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                log.error("Error reading ascii art", ex);
                return "";
            }
        }
        reader.close();
        return string;
    }

    private AsciiArt() {
    }
}

