/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.util.DateUtils;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

public class CachedValue<T> {
    private final Supplier<T> valueSupplier;
    private final Duration maximumAge;
    private final Supplier<Boolean> isExpired;
    private final Function<Duration, Boolean> isExpiredBasedOnDuration;
    private T value = null;
    private Long lastUpdate = null;

    private CachedValue(Supplier<T> valueSupplier, Duration maximumAge, Supplier<Boolean> isExpired, Function<Duration, Boolean> isExpiredBasedOnDuration) {
        this.valueSupplier = valueSupplier;
        this.maximumAge = maximumAge;
        this.isExpired = isExpired;
        this.isExpiredBasedOnDuration = isExpiredBasedOnDuration;
    }

    public CachedValue(Supplier<T> valueSupplier, Duration maximumAge) {
        this(valueSupplier, maximumAge, () -> false, d -> false);
    }

    public CachedValue(Supplier<T> valueSupplier, Integer maximumSecondsAge) {
        this(valueSupplier, maximumSecondsAge == null ? null : Duration.ofSeconds(maximumSecondsAge.intValue()));
    }

    public CachedValue(Supplier<T> valueSupplier) {
        this(valueSupplier, (Duration)null);
    }

    public synchronized T get() {
        if (this.isExpired()) {
            this.set(this.valueSupplier.get());
        }
        return this.value;
    }

    public synchronized void set(T value) {
        this.value = value;
        this.lastUpdate = System.currentTimeMillis();
    }

    public synchronized void expire() {
        this.lastUpdate = null;
    }

    private boolean isExpired() {
        return this.lastUpdate == null || this.isExpired.get() != false || this.isExpiredBasedOnDuration.apply(DateUtils.durationSince(this.lastUpdate)) != false || this.maximumAge != null && DateUtils.millisSince(this.lastUpdate) > this.maximumAge.toMillis();
    }

    public static <T> Builder<T> build(Supplier<T> valueSupplier) {
        return new Builder<T>(valueSupplier);
    }

    public static class Builder<T> {
        private final Supplier<T> valueSupplier;
        private Duration maximumAge = null;
        private Supplier<Boolean> isExpired = () -> false;
        private Function<Duration, Boolean> isExpiredBasedOnDuration = d -> false;

        private Builder(Supplier<T> valueSupplier) {
            this.valueSupplier = valueSupplier;
        }

        public Builder<T> maximumAge(Duration maximumAge) {
            this.maximumAge = maximumAge;
            return this;
        }

        public Builder<T> isExpired(Supplier<Boolean> isExpired) {
            this.isExpired = isExpired;
            return this;
        }

        public Builder<T> isExpiredBasedOnAge(Function<Duration, Boolean> isExpired) {
            this.isExpiredBasedOnDuration = isExpired;
            return this;
        }

        public Builder<T> expiredIfOlderThanDuration(Supplier<Duration> durationSupplier) {
            return this.isExpiredBasedOnAge(d -> ((Duration)durationSupplier.get()).toMillis() < d.toMillis());
        }

        public CachedValue<T> complete() {
            return new CachedValue<T>(this.valueSupplier, this.maximumAge, this.isExpired, this.isExpiredBasedOnDuration);
        }
    }
}

