/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.util.BinaryUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public record DaysOfWeek(boolean monday, boolean tuesday, boolean wednesday, boolean thursday, boolean friday, boolean saturday, boolean sunday) {
    public boolean everyDaySelected() {
        return this.getSelectedDaysCount() == 7;
    }

    public boolean noDaySelected() {
        return this.getSelectedDaysCount() == 0;
    }

    public int getSelectedDaysCount() {
        return (int)Arrays.stream(this.getBinaryArray()).filter(Boolean.TRUE::equals).count();
    }

    public List<DayOfWeek> getDays() {
        ArrayList<DayOfWeek> daysOfWeek = new ArrayList<DayOfWeek>(7);
        if (this.monday) {
            daysOfWeek.add(DayOfWeek.MONDAY);
        }
        if (this.tuesday) {
            daysOfWeek.add(DayOfWeek.TUESDAY);
        }
        if (this.wednesday) {
            daysOfWeek.add(DayOfWeek.WEDNESDAY);
        }
        if (this.thursday) {
            daysOfWeek.add(DayOfWeek.THURSDAY);
        }
        if (this.friday) {
            daysOfWeek.add(DayOfWeek.FRIDAY);
        }
        if (this.saturday) {
            daysOfWeek.add(DayOfWeek.SATURDAY);
        }
        if (this.sunday) {
            daysOfWeek.add(DayOfWeek.SUNDAY);
        }
        return daysOfWeek;
    }

    public Integer toInteger() {
        Boolean[] binaryArray = this.getBinaryArray();
        return BinaryUtils.convertBinaryBooleanArrayToInteger(binaryArray);
    }

    public boolean isToday() {
        LocalDate now = LocalDate.now();
        return switch (now.getDayOfWeek()) {
            default -> throw new IncompatibleClassChangeError();
            case DayOfWeek.MONDAY -> this.monday;
            case DayOfWeek.TUESDAY -> this.tuesday;
            case DayOfWeek.WEDNESDAY -> this.wednesday;
            case DayOfWeek.THURSDAY -> this.thursday;
            case DayOfWeek.FRIDAY -> this.friday;
            case DayOfWeek.SATURDAY -> this.saturday;
            case DayOfWeek.SUNDAY -> this.sunday;
        };
    }

    private Boolean[] getBinaryArray() {
        return new Boolean[]{this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday, this.sunday};
    }

    public static DaysOfWeek fromInt(Integer value) {
        Boolean[] binaryArray = BinaryUtils.convertIntegerToBinaryBooleanArray(value, 7);
        return new DaysOfWeek(binaryArray[0], binaryArray[1], binaryArray[2], binaryArray[3], binaryArray[4], binaryArray[5], binaryArray[6]);
    }

    public static DaysOfWeek getAllDays() {
        return new DaysOfWeek(true, true, true, true, true, true, true);
    }

    public static DaysOfWeek getNoDays() {
        return new DaysOfWeek(false, false, false, false, false, false, false);
    }
}

