/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public class DelegateProcessor
implements AutoCloseable {
    private final ExecutorService executor;
    private boolean active = true;

    public static DelegateProcessor getNewDelegateProcessor() {
        return DelegateProcessor.getNewDelegateProcessor(5);
    }

    public static DelegateProcessor getNewDelegateProcessor(int threadCount) {
        return new DelegateProcessor(threadCount);
    }

    private DelegateProcessor(int threadCount) {
        this.executor = Executors.newFixedThreadPool(threadCount);
    }

    public <T> Future<T> delegate(Supplier<T> supplier) {
        if (!this.active) {
            throw new IllegalStateException("This delegate processor has been closed");
        }
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            Object value = supplier.get();
            future.complete(value);
        });
        return future;
    }

    public void delegate(Runnable runnable2) {
        if (!this.active) {
            throw new IllegalStateException("This delegate processor has been closed");
        }
        this.executor.execute(runnable2);
    }

    @Override
    public void close() {
        this.active = false;
        this.executor.shutdownNow();
    }
}

