/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.Objects;

public final class Distance
implements Comparable<Distance> {
    private final Number lowerValue;
    private final Number upperValue;

    private Distance(Number lowerValue, Number upperValue) {
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    public int getIntDistance() {
        return this.upperValue.intValue() - this.lowerValue.intValue();
    }

    public double getDoubleDistance() {
        return this.upperValue.doubleValue() - this.lowerValue.doubleValue();
    }

    public long getLongDistance() {
        return this.upperValue.longValue() - this.lowerValue.longValue();
    }

    public float getFloatDistance() {
        return this.upperValue.floatValue() - this.lowerValue.floatValue();
    }

    public static Distance of(Number lowerValue, Number upperValue) {
        Objects.requireNonNull(lowerValue, "Must supply a lower value");
        Objects.requireNonNull(upperValue, "Must supply an upper value");
        return new Distance(lowerValue, upperValue);
    }

    @Override
    public int compareTo(Distance o) {
        return Double.compare(this.getDoubleDistance(), o.getDoubleDistance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distance distance = (Distance)o;
        return Objects.equals(this.lowerValue, distance.lowerValue) && Objects.equals(this.upperValue, distance.upperValue);
    }

    public int hashCode() {
        return Objects.hash(this.lowerValue, this.upperValue);
    }

    public String toString() {
        return this.lowerValue.toString() + " - " + this.upperValue.toString();
    }
}

