/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.time.Duration;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DurationFormatter {
    public static String formatDuration(long millis) {
        return DurationFormatter.formatDuration(Duration.ofMillis(millis));
    }

    public static String formatDuration(Duration duration) {
        int days = (int)duration.toDays();
        int hours = duration.toHoursPart();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        if (days == 0 && hours == 0 && minutes == 0 && seconds == 0) {
            return "0d 0h 0m 0s";
        }
        Object daysString = days > 0 ? days + "d" : "";
        Object hoursString = hours > 0 ? hours + "h" : "";
        Object minutesString = minutes > 0 ? minutes + "m" : "";
        Object secondsString = seconds > 0 ? seconds + "s" : "";
        return Stream.of(daysString, hoursString, minutesString, secondsString).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(" "));
    }

    private DurationFormatter() {
    }
}

