/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.i18n.I18n;
import java.util.concurrent.ThreadLocalRandom;

public enum HorseGender {
    STALLION("horse.gender.stallion"),
    MARE("horse.gender.mare"),
    GELDING("horse.gender.gelding");

    private final String resourceKey;

    private HorseGender(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public String getTranslatedName() {
        return I18n.getLabel(this.resourceKey);
    }

    public HorseGender opposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STALLION -> MARE;
            case MARE -> STALLION;
            case GELDING -> throw new IllegalArgumentException("Gelding does not have an opposite gender");
        };
    }

    public static HorseGender getRandomGender() {
        if (ThreadLocalRandom.current().nextBoolean()) {
            return STALLION;
        }
        return MARE;
    }
}

