/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ListMap<K, T> {
    private final Map<K, List<T>> map = new HashMap<K, List<T>>();

    public synchronized void add(K key, T value) {
        List<T> list = this.map.get(key);
        if (list != null) {
            list.add(value);
        } else {
            ArrayList<T> newList = new ArrayList<T>(1);
            newList.add(value);
            this.map.put(key, newList);
        }
    }

    public synchronized boolean has(K key) {
        return this.map.containsKey(key);
    }

    public synchronized List<T> get(K key) {
        List<T> list = this.map.get(key);
        if (list == null) {
            return Collections.emptyList();
        }
        list = new ArrayList<T>(list);
        return Collections.unmodifiableList(list);
    }

    public synchronized Optional<T> getSingle(K key) {
        List<T> list = this.get(key);
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
    }

    public synchronized Set<K> getAllKeys() {
        return this.map.keySet();
    }

    public synchronized void remove(K key, T value) {
        List<T> list = this.map.get(key);
        if (list != null) {
            list.remove(value);
        }
    }

    public synchronized void clear(K key) {
        this.map.remove(key);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

