/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class MapAdapter<K, V>
implements Map<K, V> {
    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    final class KeySet
    extends AbstractSet<K> {
        private final List<K> backingList;

        public KeySet() {
            this.backingList = MapAdapter.this.entrySet().stream().map(Map.Entry::getKey).toList();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return MapAdapter.this.size();
        }

        final class KeySetIterator
        implements Iterator<K> {
            private int currentIndex = 0;

            KeySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return KeySet.this.size() > this.currentIndex;
            }

            @Override
            public K next() {
                if (this.hasNext()) {
                    return KeySet.this.backingList.get(this.currentIndex++);
                }
                throw new NoSuchElementException();
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final List<V> backingList;

        public Values() {
            this.backingList = MapAdapter.this.entrySet().stream().map(Map.Entry::getValue).toList();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int size() {
            return MapAdapter.this.size();
        }

        final class ValuesIterator
        implements Iterator<V> {
            private int currentIndex = 0;

            ValuesIterator() {
            }

            @Override
            public boolean hasNext() {
                return Values.this.size() > this.currentIndex;
            }

            @Override
            public V next() {
                if (this.hasNext()) {
                    return Values.this.backingList.get(this.currentIndex++);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

