/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.text.DecimalFormat;
import java.util.Objects;

public class NumberFormatter {
    public static String formatNumber(double value, String format) {
        return new DecimalFormat(format).format(value);
    }

    public static String format2DP(double value) {
        return NumberFormatter.formatNumber(value, "###,###,##0.00");
    }

    public static String format1DP(double value) {
        return NumberFormatter.formatNumber(value, "###,###,##0.0");
    }

    public static String formatWholeNumber(double value) {
        return NumberFormatter.formatNumber(value, "###,###,##0");
    }

    public static boolean isNumber(String val) {
        Objects.requireNonNull(val, "Must supply a value");
        if (val.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(val);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private NumberFormatter() {
    }
}

