/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.PasswordException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordEncryptor {
    public String encrypt(String password, String salt) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65535, 128);
            SecretKeyFactory factory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = factory2.generateSecret(spec).getEncoded();
            return this.toBytes(hash);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new PasswordException(ex);
        }
    }

    public String generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return this.toBytes(salt);
    }

    private String toBytes(byte[] salt) {
        StringBuilder sb = new StringBuilder();
        for (byte b : salt) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public boolean checkPassword(String password, String storedHashedPassword) {
        String[] passwordArray = storedHashedPassword.split(":");
        String passwordSalt = passwordArray[0];
        String currentPassword = passwordArray[1];
        String hashedPassword = this.encrypt(password, passwordSalt);
        return hashedPassword.equals(currentPassword);
    }
}

