/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PlayerDataUpdateMessage
implements Serializable {
    private final int playerId;
    private final List<UpdateField> fieldUpdates;

    private PlayerDataUpdateMessage(int playerId, List<UpdateField> fieldUpdates) {
        this.playerId = playerId;
        this.fieldUpdates = fieldUpdates;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public List<UpdateField> getFieldUpdates() {
        return this.fieldUpdates;
    }

    public static class Builder {
        private final int playerId;
        private final List<UpdateField> updateFields = new ArrayList<UpdateField>();

        private Builder(int playerId) {
            this.playerId = playerId;
        }

        public <T extends Serializable> Builder withField(String name, T value) {
            UpdateField updateField = new UpdateField(name, value);
            this.updateFields.add(updateField);
            return this;
        }

        public PlayerDataUpdateMessage complete() {
            return new PlayerDataUpdateMessage(this.playerId, this.updateFields);
        }

        public static Builder start(int playerId) {
            return new Builder(playerId);
        }
    }

    public static class UpdateField
    implements Serializable {
        private final String fieldName;
        private final Serializable fieldValue;

        private UpdateField(String fieldName, Serializable fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Serializable getFieldValue() {
            return this.fieldValue;
        }
    }
}

