/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

public enum QuestType {
    STANDARD(true),
    TUTORIAL(false),
    SPECIALIZED(false);

    private final String menuTitleKey = String.format("quest.type.%s.menu.title", this.name().toLowerCase());
    private final String startedTitleKey = String.format("quest.type.%s.title.started", this.name().toLowerCase());
    private final String completedTitleKey = String.format("quest.type.%s.title.completed", this.name().toLowerCase());
    private final String failedTitleKey = String.format("quest.type.%s.title.failed", this.name().toLowerCase());
    private final String abandonedTitleKey = String.format("quest.type.%s.title.abandoned", this.name().toLowerCase());
    private final boolean canBeReset;

    private QuestType(boolean canBeReset) {
        this.canBeReset = canBeReset;
    }

    public String getMenuTitleKey() {
        return this.menuTitleKey;
    }

    public String getStartedTitleKey() {
        return this.startedTitleKey;
    }

    public String getCompletedTitleKey() {
        return this.completedTitleKey;
    }

    public String getFailedTitleKey() {
        return this.failedTitleKey;
    }

    public String getAbandonedTitleKey() {
        return this.abandonedTitleKey;
    }

    public boolean isCanBeReset() {
        return this.canBeReset;
    }

    public boolean isStandard() {
        return this == STANDARD;
    }

    public boolean isTutorial() {
        return this == TUTORIAL;
    }

    public boolean isSpecialized() {
        return this == SPECIALIZED;
    }
}

