/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.Distance;
import java.util.Objects;

public final class Range<T extends Comparable<T>> {
    private final T lowerBound;
    private final T upperBound;
    private static final String STR_MUST_SUPPLY_VALUE = "Must supply a value";
    private static final String SRT_NO_LOWER_BOUND = "Range does not have a lower bound";
    private static final String STR_NO_UPPER_BOUND = "Range does not have an upper bound";

    private Range(T lowerBound, T upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public T getLowerBound() {
        return this.lowerBound;
    }

    public T getUpperBound() {
        return this.upperBound;
    }

    public boolean containsValueWithin(T value) {
        Objects.requireNonNull(value, STR_MUST_SUPPLY_VALUE);
        return !(this.lowerBound != null && this.lowerBound.compareTo(value) > 0 || this.upperBound != null && this.upperBound.compareTo(value) < 0);
    }

    public boolean valueBelowRange(T value) {
        Objects.requireNonNull(value, STR_MUST_SUPPLY_VALUE);
        Objects.requireNonNull(this.lowerBound, SRT_NO_LOWER_BOUND);
        return value.compareTo(this.lowerBound) < 0;
    }

    public boolean valueAboveRange(T value) {
        Objects.requireNonNull(value, STR_MUST_SUPPLY_VALUE);
        Objects.requireNonNull(this.upperBound, STR_NO_UPPER_BOUND);
        return value.compareTo(this.upperBound) > 0;
    }

    public Distance getDistance() {
        T t = this.lowerBound;
        if (t instanceof Number) {
            Number lowerBoundNumber = (Number)t;
            t = this.upperBound;
            if (t instanceof Number) {
                Number upperBoundNumber = (Number)t;
                return Distance.of(lowerBoundNumber, upperBoundNumber);
            }
        }
        throw new IllegalArgumentException("Can only get the distance of a numerical range");
    }

    public static <T extends Comparable<T>> Range<T> of(T lowerBound, T upperBound) {
        Range.ensureBoundsAreValid(lowerBound, upperBound);
        return new Range<T>(lowerBound, upperBound);
    }

    private static <T extends Comparable<T>> void ensureBoundsAreValid(T lowerBound, T upperBound) {
        if (lowerBound == null || upperBound == null) {
            return;
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException(String.format("Lower bound value %s cannot be greater than upper bound value %s", lowerBound, upperBound));
        }
    }
}

